//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * _OVXewb_
 * @author Junpee
 */

#ifndef RENDERING_SYSTEM_H_
#define RENDERING_SYSTEM_H_

//------------------------------------------------------------------------------
/**
 * _OVXe
 */
class RenderingSystem{
friend class GameSystem;
public:
	//--------------------------------------------------------------------------
	/**
	 * CX^X̎擾
	 * @return CX^X
	 */
	static RenderingSystem* getInstance(){ return instance_; }

	//--------------------------------------------------------------------------
	/**
	 * wiNA
	 * @param color NAJ[
	 */
	virtual void clearBackground(Color4c color = Color4c::gray);

	/**
	 * go[X
	 */
	virtual void traverse();

	/**
	 * _O
	 */
	virtual void renderingSetup();

	/**
	 * _O
	 */
	virtual void rendering();

	/**
	 * NA
	 */
	virtual void clear();

	//--------------------------------------------------------------------------
	// oANZX
	//--------------------------------------------------------------------------
	/**
	 * XvCg_̎擾
	 * @return XvCg_
	 */
	virtual SpriteRenderer* getSpriteRenderer(){ return spriteRenderer_; }

	/**
	 * _̎擾
	 * @return _
	 */
	virtual Renderer* getRenderer(){ return renderer_; }

	/**
	 * V[̎擾
	 * @return V[
	 */
	virtual Scene* getScene(){ return scene_; }

	/**
	 * J̎擾
	 * @return J
	 */
	virtual Camera* getCamera(){ return camera_; }

	/**
	 * Aj[V}l[W̎擾
	 * @return Aj[V}l[W
	 */
	virtual AnimationManager* getAnimationManager(){
		return animationManager_;
	}

	/**
	 * JRg[̎s
	 */
	virtual void runCameraController();

protected:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	RenderingSystem();

	/**
	 * fXgN^
	 */
	virtual ~RenderingSystem();

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	RenderingSystem(const RenderingSystem& copy);

	// Rs[̉B
	void operator =(const RenderingSystem& copy);

	// XvCg_
	SpriteRenderer* spriteRenderer_;
	// _
	Renderer* renderer_;
	// V[
	Scene* scene_;
	// J
	Camera* camera_;
	// Aj[V}l[W
	AnimationManager* animationManager_;
	// JRg[
	PS2PadCameraController* cameraController_;
	// ftHgJʒu
	Vector3 defaultCameraPosition_;

	// CX^X
	static RenderingSystem* instance_;
};

//------------------------------------------------------------------------------
#endif // End of RENDERING_SYSTEM_H_
//------------------------------------------------------------------------------
