//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * _OVXe
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Game/Rendering/RenderingSystem.h"

// CX^X
RenderingSystem* RenderingSystem::instance_ = NULL;

//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
RenderingSystem::RenderingSystem() : defaultCameraPosition_(0.f, 40.f, 80.f){
	// CX^X|C^ݒ
	Assert(instance_ == NULL);
	instance_ = this;
	// XvCg_
	spriteRenderer_ = new SpriteRenderer();
	// _
	renderer_ = new Renderer();
	// V[̍쐬
	scene_ = LampGraphics::createScene("Scene");
	// JRg[A2Ԗڂ̃pbhgpłȂgp
	cameraController_ = new PS2PadCameraController();
	if(LampInput::getJoystickCount() > 1){
		if(PS2Pad::checkCompatibility(LampInput::getJoystick(1))){
			cameraController_->setJoystick(LampInput::getJoystick(1));
		}
	}
	// J̍쐬
	camera_ = scene_->getCameraManager()->createCamera("camera");
	camera_->setTransformation(Vector3::zero, defaultCameraPosition_);
	scene_->setCurrentCamera(camera_);
	cameraController_->setCamera(camera_);
	// Aj[V}l[W̍쐬
	animationManager_ = new AnimationManager();
}
//------------------------------------------------------------------------------
// fXgN^
RenderingSystem::~RenderingSystem(){
	// Aj[V}l[W̔j
	int animationCount = animationManager_->clear();
	Assert(animationCount == 0);
	delete animationManager_;
	// J̔j
	scene_->getCameraManager()->destroy(camera_);
	// JRg[̔j
	SafeDelete(cameraController_);
	// V[̔j
	int sceneObjectCount = scene_->clear();
	Assert(sceneObjectCount == 0);
	LampGraphics::destroyScene(scene_);
	// _̔j
	SafeDelete(renderer_);
	// XvCg_̔j
	SafeDelete(spriteRenderer_);
	// CX^X|C^n
	Assert(instance_ == this);
	instance_ = NULL;
}
//------------------------------------------------------------------------------
// wiNA
void RenderingSystem::clearBackground(Color4c color){
	GraphicsDevice::getInstance()->clear(Color4c::black);
}
//------------------------------------------------------------------------------
// go[X
void RenderingSystem::traverse(){
	scene_->traverse();
}
//------------------------------------------------------------------------------
// _O
void RenderingSystem::renderingSetup(){
	renderer_->renderingSetup(scene_);
}
//------------------------------------------------------------------------------
// _O
void RenderingSystem::rendering(){
	renderer_->rendering();
	spriteRenderer_->render();
}
//------------------------------------------------------------------------------
// NA
void RenderingSystem::clear(){
	scene_->clear();
	// J̍쐬
	camera_ = scene_->getCameraManager()->createCamera("camera");
	camera_->setTransformation(Vector3::zero, defaultCameraPosition_);
	scene_->setCurrentCamera(camera_);
	cameraController_->setCamera(camera_);
}
//------------------------------------------------------------------------------
// JRg[̎s
void RenderingSystem::runCameraController(){
	cameraController_->control();
}
//------------------------------------------------------------------------------
