//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ̓VXewb_
 * @author Junpee
 */

#ifndef INPUT_SYSTEM_H_
#define INPUT_SYSTEM_H_

class GamePad;

//------------------------------------------------------------------------------
/**
 * ̓VXe
 */
class InputSystem{
friend class GameSystem;
public:
	//--------------------------------------------------------------------------
	/**
	 * CX^X̎擾
	 * @return CX^X
	 */
	static InputSystem* getInstance(){ return instance_; }

	//--------------------------------------------------------------------------
	// oANZX
	//--------------------------------------------------------------------------
	/**
	 * L[{[h̎擾
	 * @return L[{[h
	 */
	virtual Keyboard* getKeyboard(){ return keyboard; }

	/**
	 * }EX̎擾
	 * @return }EX
	 */
	virtual Mouse* getMouse(){ return mouse_; }

	/**
	 * pbh̎擾
	 * @return pbh
	 */
	virtual GamePad* getGamePad(){ return pad_; }

protected:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	InputSystem();

	/**
	 * fXgN^
	 */
	virtual ~InputSystem();

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	InputSystem(const InputSystem& copy);

	// Rs[̉B
	void operator =(const InputSystem& copy);

	// L[{[h
	Keyboard* keyboard;
	// }EX
	Mouse* mouse_;
	// pbh
	GamePad* pad_;

	// CX^X
	static InputSystem* instance_;
};

//------------------------------------------------------------------------------
#endif // End of INPUT_SYSTEM_H_
//------------------------------------------------------------------------------
