//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ̓VXe
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Game/Input/InputSystem.h"
#include "Game/Input/GamePad.h"

// CX^X
InputSystem* InputSystem::instance_ = NULL;

//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
InputSystem::InputSystem(){
	// CX^X|C^ݒ
	Assert(instance_ == NULL);
	instance_ = this;
	// L[{[h
	keyboard = LampInput::getKeyboard();
	// }EX̍쐬
	mouse_ = LampInput::getMouse();
	// pbh̏A1Ԗڂ̃pbhgpłȂgp
	pad_ = NULL;
	if(LampInput::getJoystickCount() > 0){
		if(GamePad::checkCompatibility(LampInput::getJoystick(0))){
			pad_ = new GamePad(LampInput::getJoystick(0));
		}
	}
}
//------------------------------------------------------------------------------
// fXgN^
InputSystem::~InputSystem(){
	// pbh̔j
	SafeDelete(pad_);
	// CX^X|C^n
	Assert(instance_ == this);
	instance_ = NULL;
}
//------------------------------------------------------------------------------
