//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * RWVXewb_
 * @author Junpee
 */

#ifndef COLLISION_SYSTEM_H_
#define COLLISION_SYSTEM_H_

//------------------------------------------------------------------------------
/**
 * RWVXe
 */
class CollisionSystem{
friend class GameSystem;
public:
	//--------------------------------------------------------------------------
	/**
	 * CX^X̎擾
	 * @return CX^X
	 */
	static CollisionSystem* getInstance(){ return instance_; }

	//--------------------------------------------------------------------------
	/**
	 * go[X
	 */
	virtual void traverse();

	/**
	 * _O
	 */
	virtual void renderingSetup();

	/**
	 * _O
	 */
	virtual void rendering();

	/**
	 * NA
	 */
	virtual void clear();

	//--------------------------------------------------------------------------
	// oANZX
	//--------------------------------------------------------------------------
	/**
	 * V[̎擾
	 * @return V[
	 */
	virtual CollisionScene* getScene(){ return scene_; }

	/**
	 * _̎擾
	 * @return _
	 */
	virtual CollisionRenderer* getRenderer(){ return renderer_; }

protected:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	CollisionSystem();

	/**
	 * fXgN^
	 */
	virtual ~CollisionSystem();

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	CollisionSystem(const CollisionSystem& copy);

	// Rs[̉B
	void operator =(const CollisionSystem& copy);

	// V[
	CollisionScene* scene_;
	// _
	CollisionRenderer* renderer_;

	// CX^X
	static CollisionSystem* instance_;
};

//------------------------------------------------------------------------------
#endif // End of COLLISION_SYSTEM_H_
//------------------------------------------------------------------------------
