//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * RWVXe
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Game/Collision/CollisionSystem.h"
#include "Game/Rendering/RenderingSystem.h"

// CX^X
CollisionSystem* CollisionSystem::instance_ = NULL;

//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
CollisionSystem::CollisionSystem(){
	// CX^X|C^ݒ
	Assert(instance_ == NULL);
	instance_ = this;

	// RWV[̐
	scene_ = new CollisionScene();
	// RW_̐
	renderer_ = new CollisionRenderer();
}
//------------------------------------------------------------------------------
// fXgN^
CollisionSystem::~CollisionSystem(){
	// RW_̔j
	SafeDelete(renderer_);
	// RWV[̔j
	int collisionObjectCount = scene_->clear();
	Assert(collisionObjectCount == 0);
	SafeDelete(scene_);

	// CX^X|C^n
	Assert(instance_ == this);
	instance_ = NULL;
}
//------------------------------------------------------------------------------
// go[X
void CollisionSystem::traverse(){
	scene_->traverse();
}
//------------------------------------------------------------------------------
// _O
void CollisionSystem::renderingSetup(){
	renderer_->renderingSetup(scene_,
		RenderingSystem::getInstance()->getCamera());
}
//------------------------------------------------------------------------------
// _O
void CollisionSystem::rendering(){
	renderer_->rendering();
}
//------------------------------------------------------------------------------
// NA
void CollisionSystem::clear(){
	scene_->clear();
}
//------------------------------------------------------------------------------
