//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Aj[VVXewb_
 * @author Junpee
 */

#ifndef ANIMATION_SYSTEM_H_
#define ANIMATION_SYSTEM_H_

//------------------------------------------------------------------------------
/**
 * Aj[VVXe
 */
class AnimationSystem{
friend class GameSystem;
public:
	//--------------------------------------------------------------------------
	/**
	 * CX^X̎擾
	 * @return CX^X
	 */
	static AnimationSystem* getInstance(){ return instance_; }

	//--------------------------------------------------------------------------
	/**
	 * Aj[V}l[W̎擾
	 * @return Aj[V}l[W
	 */
	virtual AnimationManager* getAnimationManager(){ return animationManager_; }

	/**
	 * NA
	 */
	virtual void clear();

protected:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	AnimationSystem();

	/**
	 * fXgN^
	 */
	virtual ~AnimationSystem();

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	AnimationSystem(const AnimationSystem& copy);

	// Rs[̉B
	void operator =(const AnimationSystem& copy);

	//--------------------------------------------------------------------------
	// Aj[V}l[W
	AnimationManager* animationManager_;

	// CX^X
	static AnimationSystem* instance_;

};

//------------------------------------------------------------------------------
#endif // End of ANIMATION_SYSTEM_H_
//------------------------------------------------------------------------------
