//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ^k[Ԏ
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Enemy/Tanue/TanueState.h"
#include "Enemy/Tanue/Tanue.h"

#include "Stage/System/Stage.h"
#include "Enemy/Tanue/TanueBigDamageState.h"
#include "Enemy/Tanue/TanueSmallDamageState.h"

#include "Player/System/PlayerSystem.h"
#include "Player/System/Player.h"

//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
TanueState::TanueState(Tanue* tanue) :
	EnemyState(tanue), tanue_(tanue){
}
//------------------------------------------------------------------------------
// fXgN^
TanueState::~TanueState(){
}
//------------------------------------------------------------------------------
// _[W󂯂
bool TanueState::isDamaged(){
	// GJE^
	int matchlessCounter = getMatchlessCounter();
	if(matchlessCounter > 0){
		matchlessCounter--;
		setMatchlessCounter(matchlessCounter);
		clearDamage();
		return false;
	}
	// _[W
	int damageValue = getDamageValue();
	// GJE^̐ݒ̓_[WXe[gɂčs
	if(damageValue == 0){ return false; }

	// _[W
	setHealth(getHealth() - damageValue);

	// S󒆂傫_[WȂ琁
	if(isDeath() || isAerial() || (damageValue > 100)){
		getEnemy()->setState(new TanueBigDamageState(getTanue()));
	}else{
		getEnemy()->setState(new TanueSmallDamageState(getTanue()));
	}
	return true;
}
//------------------------------------------------------------------------------
