//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ^k[Ԏ
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Enemy/Tanue/TanueStandState.h"
#include "Enemy/System/Enemy.h"
#include "Stage/System/Stage.h"

#include "Enemy/Tanue/TanueRunState.h"
#include "Enemy/Tanue/TanueAttackState.h"
#include "Enemy/Tanue/TanueDashAttackState.h"

//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
TanueStandState::TanueStandState(Tanue* tanue) : TanueState(tanue){
}
//------------------------------------------------------------------------------
// fXgN^
TanueStandState::~TanueStandState(){
}
//------------------------------------------------------------------------------
// s
//------------------------------------------------------------------------------
// 
void TanueStandState::initialize(){
	// Aj[VV[PXݒ
	getAnimation()->setSequence(2);
}
//------------------------------------------------------------------------------
// n
void TanueStandState::finalize(){
}
//------------------------------------------------------------------------------
// s
void TanueStandState::run(){
	// 萔
	float animationScale = 1.f;

	// Xe[gύX
	if(!isDamaged()){
		if((getRandom().get() % 60) == 0){
			getEnemy()->setState(new TanueRunState(getTanue()));
		}else if((getPlayerDistance().getLength() > 30.f) &&
			((getRandom().get() % 180) == 0)){
			getEnemy()->setState(new TanueDashAttackState(getTanue()));
		}else if((getPlayerDistance().getLength() < 20.f) &&
			((getRandom().get() % 60) == 0)){
			getEnemy()->setState(new TanueAttackState(getTanue()));
		}
	}

	// ʒuƑx̌vZ
	calcVelocityAndPosition();

	// ̐ݒ
	setDirection(getPlayerDirection());

	// n`RW
	landCollide();

	// `ZbgAbv
	drawSetup(animationScale);
}
//------------------------------------------------------------------------------
