//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ^k[_[WԎ
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Enemy/Tanue/TanueSmallDamageState.h"
#include "Game/Sound/SoundSystem.h"
#include "Enemy/System/Enemy.h"

#include "Enemy/Tanue/TanueRunState.h"

//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
TanueSmallDamageState::TanueSmallDamageState(Tanue* tanue) :
	TanueState(tanue){
}
//------------------------------------------------------------------------------
// fXgN^
TanueSmallDamageState::~TanueSmallDamageState(){
}
//------------------------------------------------------------------------------
// s
//------------------------------------------------------------------------------
// 
void TanueSmallDamageState::initialize(){
	// ̐ݒ
	Vector3 direction = -getDamageDirection();
	direction.y = 0.f;
	setDirection(direction);
	clearDamage();
	// Aj[VV[PXݒ
	getAnimation()->setSequence(4);
	// Ƒx̏
	setVelocity(getDirection() * -1.f);
	// GJE^ݒ
	setMatchlessCounter(10);
	// 炷
	getSoundSystem()->play("TanueSmallDamage");
}
//------------------------------------------------------------------------------
// n
void TanueSmallDamageState::finalize(){
}
//------------------------------------------------------------------------------
// s
void TanueSmallDamageState::run(){
	// 萔
	float animationScale = 1.f;

	// Xe[gύX
	if(getRunCounter() == 30){
		getEnemy()->setState(new TanueRunState(getTanue()));
	}

	// ʒuƑx̌vZ
	calcVelocityAndPosition(getDirection() * -0.3f);

	// n`RW
	landCollide();

	// `ZbgAbv
	drawSetup(animationScale);

}
//------------------------------------------------------------------------------
