//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ^k[Ԏ
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Enemy/Tanue/TanueRunState.h"
#include "Game/Sound/SoundSystem.h"
#include "Enemy/System/Enemy.h"
#include "Stage/System/Stage.h"

#include "Enemy/Tanue/TanueStandState.h"
#include "Enemy/Tanue/TanueAttackState.h"

//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
TanueRunState::TanueRunState(Tanue* tanue) : TanueState(tanue){
}
//------------------------------------------------------------------------------
// fXgN^
TanueRunState::~TanueRunState(){
}
//------------------------------------------------------------------------------
// s
//------------------------------------------------------------------------------
// 
void TanueRunState::initialize(){
	// Aj[VV[PXݒ
	getAnimation()->setSequence(0);
}
//------------------------------------------------------------------------------
// n
void TanueRunState::finalize(){
}
//------------------------------------------------------------------------------
// s
void TanueRunState::run(){
	// 萔
	float animationScale = 16.f;
	float moveXZScale = 0.15f;

	if(!isDamaged()){
		if((getRandom().get() % 180) == 0){
			getEnemy()->setState(
				new TanueStandState(getTanue()));
		}else if((getPlayerDistance().getLength() < 20.f) &&
			((getRandom().get() % 60) == 0)){
			getEnemy()->setState(
				new TanueAttackState(getTanue()));
		}
	}

	// ړxNgZo
	Vector3 moveVelocity = getPlayerDirection();
	moveVelocity *= moveXZScale;

	// Aj[Vx
	animationScale *= moveVelocity.getLength();

	// ʒuƑx̌vZ
	calcVelocityAndPosition(moveVelocity);
	// ̐ݒ
	setDirection(moveVelocity);

	// n`RW
	landCollide();

	// `ZbgAbv
	drawSetup(animationScale);
}
//------------------------------------------------------------------------------
