//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ^k[_bVUԎ
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Enemy/Tanue/TanueDashAttackState.h"
#include "Game/Sound/SoundSystem.h"
#include "Enemy/System/Enemy.h"
#include "Stage/System/Stage.h"

#include "Enemy/Tanue/TanueRunState.h"

//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
TanueDashAttackState::TanueDashAttackState(Tanue* tanue) : TanueState(tanue){
}
//------------------------------------------------------------------------------
// fXgN^
TanueDashAttackState::~TanueDashAttackState(){
}
//------------------------------------------------------------------------------
// s
//------------------------------------------------------------------------------
// 
void TanueDashAttackState::initialize(){
	// Aj[VV[PXݒ
	getAnimation()->setSequence(1);
	// U
	attackDirection_ = getPlayerDirection();
	// RWLɂ
	getAttackCollision()->setEnabled(true);
	// 炷
	getSoundSystem()->play("TanueDashAttack");
}
//------------------------------------------------------------------------------
// n
void TanueDashAttackState::finalize(){
	// RW𖳌ɖ߂
	getAttackCollision()->setEnabled(false);
}
//------------------------------------------------------------------------------
// s
void TanueDashAttackState::run(){
	// 萔
	float animationScale = 4.f;
	float moveXZScale = 0.6f;

	// Xe[gύX
	if(!isDamaged()){
		if(getRunCounter() == 90){
			getEnemy()->setState(new TanueRunState(getTanue()));
		}
	}

	// ړxNgZo
	Vector3 moveVelocity = attackDirection_;
	moveVelocity *= moveXZScale;

	// Aj[Vx
	animationScale *= moveVelocity.getLength();

	// ʒuƑx̌vZ
	calcVelocityAndPosition(moveVelocity);
	// ̐ݒ
	setDirection(moveVelocity);

	// n`RW
	landCollide();

	// `ZbgAbv
	drawSetup(animationScale);

	// U
	attackCollide(getBodyBone(), Vector3(0.f, 0.f, 0.f), 8.f, 90);
}
//------------------------------------------------------------------------------
