//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * GVXewb_
 * @author Junpee
 */

#ifndef ENEMY_SYSTEM_H_
#define ENEMY_SYSTEM_H_

#include "Enemy/System/Enemy.h"
#include "Game/System/SystemReference.h"

class Stage;

//------------------------------------------------------------------------------
/**
 * GVXe
 */
class EnemySystem : public SystemReference{
friend class GameSystem;
public:
	//--------------------------------------------------------------------------
	/**
	 * CX^X̎擾
	 * @return CX^X
	 */
	static EnemySystem* getInstance(){ return instance_; }

	//--------------------------------------------------------------------------
	// [h
	//--------------------------------------------------------------------------
	/**
	 * [h
	 * @param type G[^Cv
	 */
	virtual void load(Enemy::Type type);

	//--------------------------------------------------------------------------
	/**
	 * s
	 */
	virtual void run();

	//--------------------------------------------------------------------------
	/**
	 * KillJEg̎擾
	 * @return KillJEg
	 */
	virtual int getKillCount() const{ return killCount_; }

	//--------------------------------------------------------------------------
	// G
	//--------------------------------------------------------------------------
	/**
	 * G̍쐬
	 * @param type G[^Cv
	 * @param health ̗
	 */
	virtual Enemy* create(Enemy::Type type, int health);

	/**
	 * G̔j
	 * @param enemy jG
	 */
	virtual void destroy(Enemy* enemy);

	/**
	 * G̃NA
	 */
	virtual void clear();

	/**
	 * G̎擾
	 * @return G
	 */
	virtual int getCount() const{ return enemys_.getCount(); }

	/**
	 * G̎擾
	 * @param index GCfbNX
	 * @return G
	 */
	virtual Enemy* get(int index){ return enemys_[index]; }

protected:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	EnemySystem();

	/**
	 * fXgN^
	 */
	virtual ~EnemySystem();

	/**
	 * G̐
	 */
	virtual void generate();

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	EnemySystem(const EnemySystem& copy);

	// Rs[̉B
	void operator =(const EnemySystem& copy);

	//--------------------------------------------------------------------------
	// G
	ArrayList<Enemy*> enemys_;
	// Gm[h
	SceneNode* enemyNode_;
	// _
	Random random_;
	// KillJEg
	int killCount_;

	// WFCJEg
	int gelaimCount_;
	// ^k[JEg
	int tanueCount_;
	// AUiJEg
	int azalinnaCount_;
	// CX^X
	static EnemySystem* instance_;
};

//------------------------------------------------------------------------------
#endif // End of ENEMY_SYSTEM_H_
//------------------------------------------------------------------------------
