//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * GԎ
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Enemy/System/EnemyState.h"
#include "Enemy/System/Enemy.h"
#include "Game/Input/GamePad.h"

#include "Game/Rendering/RenderingSystem.h"
#include "Player/System/PlayerSystem.h"
#include "Player/System/Player.h"

//------------------------------------------------------------------------------
// RXgN^
EnemyState::EnemyState(Enemy* enemy) :
	SystemReference(), enemy_(enemy), runCounter_(0){
	playerDistance_ = getPlayerSystem()->get(0)->getPosition() - getPosition();
}
//------------------------------------------------------------------------------
// fXgN^
EnemyState::~EnemyState(){
}
//------------------------------------------------------------------------------
// s̎
void EnemyState::runImplement(){
	playerDistance_ = getPlayerSystem()->get(0)->getPosition() - getPosition();
	run();
	runCounter_++;
}
//------------------------------------------------------------------------------
// xƈʒǔvZ
void EnemyState::calcVelocityAndPosition(Vector3 addVelocity){
	float velocityXZAttenuation = 0.6f;
	float velocityYAttenuation = 0.95f;
	Vector3 forceField(0.f, -0.1f, 0.f);
	Vector3 position = getPosition();
	Vector3 velocity = getVelocity();

	velocity += forceField;
	velocity += addVelocity;
	velocity.x *= velocityXZAttenuation;
	velocity.y *= velocityYAttenuation;
	velocity.z *= velocityXZAttenuation;
	position += velocity;
	// vZʂ̐ݒ
	setPosition(position);
	setVelocity(velocity);
}
//------------------------------------------------------------------------------
// n`RW
void EnemyState::landCollide(){
	// RW[vARecőΉ΍ő3
	Vector3 position = getPosition();
	Vector3 velocity = getVelocity();
	CollisionNode* collisionNode = getCollisionNode();
	collisionNode->setRotationXYZ(getRotation());

	for(int i = 0; i < 3; i++){
		// RẄʒuݒ
		collisionNode->setTranslation(position);
		collisionNode->traverse();

		// n`Ƃ̃RW
		IntersectionResult result;
		getCollisionScene()->intersection(&result, getLandCollision(), 1);

		if(!result.isIntersected()){ break; }

		// ˃xNg␳
		Vector3 refrection = result.getMaxRefrection();
		if(Math::abs(refrection.x) < 0.09f){ refrection.x = 0.f; }
		if(Math::abs(refrection.z) < 0.09f){ refrection.z = 0.f; }
		if(refrection.isZero()){ break; }

		// ʒu␳
		position += refrection;
		// x␳
		if(refrection.y > 0.f){
			setAerial(false);
			velocity.y = 0.f;
		}
	}
	// RWʒuݒ
	collisionNode->setTranslation(position);
	collisionNode->traverse();

	// vZʂ̐ݒ
	setPosition(position);
	setVelocity(velocity);
}
//------------------------------------------------------------------------------
// URW
void EnemyState::attackCollide(
	Bone* bone, const Vector3& offset, float size, int damage){
	// RẄʒu킹
	getModel()->buildBoneMatrix();
	StaticSphereCollision* collision = getAttackCollision();
	Vector3 center = bone->getModelMatrix() * offset;
	collision->setSphere(center, size);

	// U
	collision->traverse();
	Sphere attack = collision->getWorldSphere();
	Player* player = getPlayerSystem()->get(0);
	Sphere target = player->getDamageCollision()->getWorldSphere();
	Intersection intersection;
	if(attack.intersect(&intersection, target)){
		player->damage(getPlayerDirection(), damage);
	}

/*
	IntersectionResult result;
	getCollisionScene()->intersection(&result, getLandCollision(), 2);
	if(!result.isIntersected()){ break; }

	int count = result.getCount();
	for(int i = 0; i < count; i++){
		const Intersection& intersection = result.get(i);
	}
*/
}
//------------------------------------------------------------------------------
// `ZbgAbv
void EnemyState::drawSetup(float animationTime){
	// `ʒuݒ
	SceneNode* sceneNode = getSceneNode();
	sceneNode->setTranslation(getPosition());
	sceneNode->setRotationXYZ(getRotation());
	sceneNode->traverse();

	// Aj[V
	getAnimation()->animate(animationTime, Animation::maskPostCulling);
}
//------------------------------------------------------------------------------
// V[m[h
//------------------------------------------------------------------------------
// V[m[h̎擾
SceneNode* EnemyState::getSceneNode(){
	return enemy_->getSceneNode();
}
//------------------------------------------------------------------------------
// f
//------------------------------------------------------------------------------
// f̎擾
CharacterModel* EnemyState::getModel(){
	return enemy_->getModel();
}
//------------------------------------------------------------------------------
// U{[̎擾
Bone* EnemyState::getAttackBone(){
	return enemy_->getAttackBone();
}
//------------------------------------------------------------------------------
// ̃{[̎擾
Bone* EnemyState::getBodyBone(){
	return enemy_->getBodyBone();
}
//------------------------------------------------------------------------------
// Aj[V
//------------------------------------------------------------------------------
// Aj[V̎擾
Animation* EnemyState::getAnimation(){
	return enemy_->getAnimation();
}
//------------------------------------------------------------------------------
// RW
//------------------------------------------------------------------------------
// RWm[h̎擾
CollisionNode* EnemyState::getCollisionNode(){
	return enemy_->getCollisionNode();
}
//------------------------------------------------------------------------------
// n`RW̎擾
StaticSphereCollision* EnemyState::getLandCollision(){
	return enemy_->getLandCollision();
}
//------------------------------------------------------------------------------
// _[WRW̎擾
StaticSphereCollision* EnemyState::getDamageCollision(){
	return enemy_->getDamageCollision();
}
//------------------------------------------------------------------------------
// URW̎擾
StaticSphereCollision* EnemyState::getAttackCollision(){
	return enemy_->getAttackCollision();
}
//------------------------------------------------------------------------------
// ʒu
//------------------------------------------------------------------------------
// ʒu̐ݒ
void EnemyState::setPosition(const Vector3& position){
	enemy_->setPosition(position);
}
//------------------------------------------------------------------------------
// ʒu̎擾
const Vector3& EnemyState::getPosition() const{
	return enemy_->getPosition();
}
//------------------------------------------------------------------------------
// ]
//------------------------------------------------------------------------------
// ̐ݒ
void EnemyState::setDirection(const Vector3& direction){
	enemy_->setDirection(direction);
}
//------------------------------------------------------------------------------
// ̎擾
const Vector3& EnemyState::getDirection() const{
	return enemy_->getDirection();
}
//------------------------------------------------------------------------------
// ]̎擾
const Vector3& EnemyState::getRotation() const{
	return enemy_->getRotation();
}
//------------------------------------------------------------------------------
// x
//------------------------------------------------------------------------------
// x̐ݒ
void EnemyState::setVelocity(const Vector3& velocity){
	enemy_->setVelocity(velocity);
}
//------------------------------------------------------------------------------
// x̎擾
const Vector3& EnemyState::getVelocity() const{
	return enemy_->getVelocity();
}
//------------------------------------------------------------------------------
// 󒆃tO
//------------------------------------------------------------------------------
// 󒆃tO̐ݒ
void EnemyState::setAerial(bool isAerial){
	enemy_->setAerial(isAerial);
}
//------------------------------------------------------------------------------
// 󒆃tO̎擾
bool EnemyState::isAerial() const{
	return enemy_->isAerial();
}
//------------------------------------------------------------------------------
// Ct
//------------------------------------------------------------------------------
// ̐ݒ
void EnemyState::setLife(int life){
	enemy_->setLife(life);
}
//------------------------------------------------------------------------------
// ̎擾
int EnemyState::getLife() const{
	return enemy_->getLife();
}
//------------------------------------------------------------------------------
// ̗͂̐ݒ
void EnemyState::setHealth(int health){
	enemy_->setHealth(health);
}
//------------------------------------------------------------------------------
// ̗͂̎擾
int EnemyState::getHealth() const{
	return enemy_->getHealth();
}
//------------------------------------------------------------------------------
// ł邩
bool EnemyState::isDeath() const{
	return enemy_->isDeath();
}
//------------------------------------------------------------------------------
// SłĂ邩
bool EnemyState::isAnnihilated() const{
	return enemy_->isAnnihilated();
}
//------------------------------------------------------------------------------
// _[W
//------------------------------------------------------------------------------
// _[W̎擾
const Vector3& EnemyState::getDamageDirection() const{
	return enemy_->getDamageDirection();
}
//------------------------------------------------------------------------------
// _[Wl̎擾
int EnemyState::getDamageValue() const{
	return enemy_->getDamageValue();
}
//------------------------------------------------------------------------------
// _[W̃NA
void EnemyState::clearDamage(){
	enemy_->clearDamage();
}
//------------------------------------------------------------------------------
// GJE^̎擾
int EnemyState::getMatchlessCounter() const{
	return enemy_->getMatchlessCounter();
}
//------------------------------------------------------------------------------
// GJE^̐ݒ
void EnemyState::setMatchlessCounter(int matchlessCounter){
	enemy_->setMatchlessCounter(matchlessCounter);
}
//------------------------------------------------------------------------------
// _̎擾
Random& EnemyState::getRandom(){
	return enemy_->getRandom();
}
//------------------------------------------------------------------------------
