//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Gwb_
 * @author Junpee
 */

#ifndef ENEMY_H_
#define ENEMY_H_

#include "Game/System/SystemReference.h"

class Stage;
class EnemyState;
class Gelaim;
class Tanue;
class Azalinna;

//------------------------------------------------------------------------------
/**
 * G
 */
class Enemy : public SystemReference{
friend class EnemySystem;
friend class EnemyState;
public:
	//--------------------------------------------------------------------------
	/// G[^Cv
	enum Type{
		typeGelaim,
		typeTanue,
		typeAzalinna,
	};

	//--------------------------------------------------------------------------
	/**
	 * Ԃ̐ݒ
	 * @param state 
	 */
	virtual void setState(EnemyState* state);

	//--------------------------------------------------------------------------
	/**
	 * _[W
	 * @param damageDirection _[W
	 * @param damegeValue _[Wl
	 */
	virtual void damage(const Vector3& damageDirection, int damageValue){
		damageDirection_ = damageDirection;
		damageValue_ = damageValue;
	}

	/**
	 * _[WRW̎擾
	 * @return _[WRW
	 */
	virtual StaticSphereCollision* getDamageCollision(){
		return damageCollision_;
	}

	//--------------------------------------------------------------------------
	// o̎擾
	//--------------------------------------------------------------------------
	/**
	 * ʒu̎擾
	 * @return ʒu
	 */
	virtual const Vector3& getPosition() const{ return position_; }

	/**
	 * ]̎擾
	 * @return ]
	 */
	virtual const Vector3& getRotation(){ return rotation_; }

	/**
	 * ̎擾
	 * @return 
	 */
	virtual const Vector3& getDirection(){ return direction_; }

	/**
	 * x̎擾
	 * @return x
	 */
	virtual const Vector3& getVelocity() const{ return velocity_; }

	/**
	 * 󒆃tO̎擾
	 * @return 󒆂Ȃtrue
	 */
	virtual bool isAerial() const{ return isAerial_; }

	//--------------------------------------------------------------------------
	// Ct
	//--------------------------------------------------------------------------
	/**
	 * ̎擾
	 * @return 
	 */
	virtual int getLife() const{ return life_; }

	/**
	 * ̗͂̎擾
	 * @return ̗
	 */
	virtual int getHealth() const{ return health_; }

	/**
	 * ł邩
	 * @return łȂtrue
	 */
	virtual bool isDeath() const{ return (health_ == 0); }

	/**
	 * SłĂ邩
	 * @return SłĂtrue
	 */
	virtual bool isAnnihilated() const{ return (isDeath() && (life_ == 0)); }

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * WFCǂ
	 * @return WFCȂtrue
	 */
	virtual bool isGelaim() const{ return false; }

	/**
	 * WFCւ̃LXg
	 * @return WFCB^ႦNULLԂB
	 */
	virtual Gelaim* castGelaim() const{
		if(isGelaim()){ return (Gelaim*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * ^k[ǂ
	 * @return ^k[Ȃtrue
	 */
	virtual bool isTanue() const{ return false; }

	/**
	 * ^k[ւ̃LXg
	 * @return ^k[B^ႦNULLԂB
	 */
	virtual Tanue* castTanue() const{
		if(isTanue()){ return (Tanue*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * AUiǂ
	 * @return AUiȂtrue
	 */
	virtual bool isAzalinna() const{ return false; }

	/**
	 * AUiւ̃LXg
	 * @return AUiB^ႦNULLԂB
	 */
	virtual Azalinna* castAzalinna() const{
		if(isAzalinna()){ return (Azalinna*)this; }
		return NULL;
	}

protected:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param health ̗
	 * @param randomSeed _̎
	 */
	Enemy(int health, u_int randomSeed);

	/**
	 * fXgN^
	 */
	virtual ~Enemy();

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * f̏
	 * @param name O
	 * @param attackBone U{[
	 * @param bodyBone ̃{[
	 * @param copyMask Rs[}XN
	 * @return Rs[ꂽm[h
	 */
	virtual SceneNode* initializeModel(const String& name,
		const String& attackBone, const String& bodyBone, u_int copyMask);

	/**
	 * Aj[V̏
	 * @param name O
	 * @return Rs[ꂽAj[V
	 */
	virtual Animation* initializeAnimation(const String& name);

	/**
	 * RW̏
	 * @param name O
	 * @param landSize n`TCY
	 * @param damageSize _[WTCY
	 * @return RWm[h
	 */
	virtual CollisionNode* initializeCollision(const String& name,
		float landSize, float damageSize);

	//--------------------------------------------------------------------------
	// s
	//--------------------------------------------------------------------------
	/**
	 * s
	 */
	virtual void run();

	//--------------------------------------------------------------------------
	// V[m[h
	//--------------------------------------------------------------------------
	/**
	 * V[m[h̎擾
	 * @return V[m[h
	 */
	virtual SceneNode* getSceneNode(){ return sceneNode_; }

	//--------------------------------------------------------------------------
	// f
	//--------------------------------------------------------------------------
	/**
	 * f̎擾
	 * @return f
	 */
	virtual CharacterModel* getModel(){ return model_; }

	/**
	 * U{[̎擾
	 * @return U{[
	 */
	virtual Bone* getAttackBone(){ return attackBone_; }

	/**
	 * ̃{[̎擾
	 * @return ̃{[
	 */
	virtual Bone* getBodyBone(){ return bodyBone_; }

	//--------------------------------------------------------------------------
	// Aj[V
	//--------------------------------------------------------------------------
	/**
	 * Aj[V̎擾
	 * @return Aj[V
	 */
	virtual Animation* getAnimation(){ return animation_; }

	//--------------------------------------------------------------------------
	// RW
	//--------------------------------------------------------------------------
	/**
	 * RWm[h̎擾
	 * @return RWm[h
	 */
	virtual CollisionNode* getCollisionNode(){ return collisionNode_; }

	/**
	 * n`RW̎擾
	 * @return n`RW
	 */
	virtual StaticSphereCollision* getLandCollision(){ return landCollision_; }

	/**
	 * URW̎擾
	 * @return URW
	 */
	virtual StaticSphereCollision* getAttackCollision(){
		return attackCollision_;
	}

	//--------------------------------------------------------------------------
	// o̐ݒ
	//--------------------------------------------------------------------------
	/**
	 * ʒu̐ݒ
	 * @param position ʒu
	 */
	virtual void setPosition(const Vector3& position){ position_ = position; }

	/**
	 * ̐ݒ
	 * @param direction 
	 */
	virtual void setDirection(const Vector3& direction);

	/**
	 * x̐ݒ
	 * @param velocity x
	 */
	virtual void setVelocity(const Vector3& velocity){ velocity_ = velocity; }

	/**
	 * 󒆃tO̐ݒ
	 * @param isAerial 󒆂Ȃtrue
	 */
	virtual void setAerial(bool isAerial){ isAerial_ = isAerial; }

	//--------------------------------------------------------------------------
	// Ct
	//--------------------------------------------------------------------------
	/**
	 * ̐ݒ
	 * @param life 
	 */
	virtual void setLife(int life){
		life_ = life;
		if(life_ < 0){ life_ = 0; }
		else if(life_ > 4){ life_ = 4; }
	}

	/**
	 * ̗͂̐ݒ
	 * @param health ̗
	 */
	virtual void setHealth(int health){
		health_ = health;
		if(health_ < 0){ health_ = 0; }
		else if(health_ > 500){ health_ = 500; }
	}

	//--------------------------------------------------------------------------
	// _[W
	//--------------------------------------------------------------------------
	/**
	 * _[W̎擾
	 * @return _[W
	 */
	virtual const Vector3& getDamageDirection() const{
		return damageDirection_;
	}

	/**
	 * _[Wl̎擾
	 * @return _[Wl
	 */
	virtual int getDamageValue() const{ return damageValue_; }

	/**
	 * _[W̃NA
	 */
	virtual void clearDamage(){
		damageDirection_ = Vector3::zero;
		damageValue_ = 0;
	}

	/**
	 * GJE^̎擾
	 * @return GJE^
	 */
	virtual int getMatchlessCounter() const{ return matchlessCounter_; }

	/**
	 * GJE^̐ݒ
	 * @param matchlessCounter GJE^
	 */
	virtual void setMatchlessCounter(int matchlessCounter){
		Assert(matchlessCounter >= 0);
		matchlessCounter_ = matchlessCounter;
	}

	//--------------------------------------------------------------------------
	/**
	 * _̎擾
	 * @return _
	 */
	virtual Random& getRandom(){ return random_; }

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	Enemy(const Enemy& copy);

	// Rs[̉B
	void operator =(const Enemy& copy);

	//--------------------------------------------------------------------------
	// o
	//--------------------------------------------------------------------------
	// Xe[W
	Stage* stage_;
	// V[m[h
	SceneNode* sceneNode_;
	// f
	CharacterModel* model_;
	// U{[
	Bone* attackBone_;
	// ̃{[
	Bone* bodyBone_;
	// Aj[V
	Animation* animation_;
	// RWm[h
	CollisionNode* collisionNode_;
	// n`RW
	StaticSphereCollision* landCollision_;
	// _[WRW
	StaticSphereCollision* damageCollision_;
	// URW
	StaticSphereCollision* attackCollision_;

	// 
	EnemyState* state_;
	// ̏
	EnemyState* nextState_;
	// ʒu
	Vector3 position_;
	// ]
	Vector3 rotation_;
	// 
	Vector3 direction_;
	// x
	Vector3 velocity_;
	// 󒆃tO
	bool isAerial_;

	// 
	int life_;
	// ̗
	int health_;

	// _[W
	Vector3 damageDirection_;
	// _[Wl
	int damageValue_;
	// GJE^
	int matchlessCounter_;

	// _
	Random random_;
};

//------------------------------------------------------------------------------
#endif // End of ENEMY_H_
//------------------------------------------------------------------------------
