//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * WFCԎ
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Enemy/Gelaim/GelaimStandState.h"
#include "Enemy/System/Enemy.h"
#include "Stage/System/Stage.h"

#include "Enemy/Gelaim/GelaimRunState.h"
#include "Enemy/Gelaim/GelaimAttackState.h"

//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
GelaimStandState::GelaimStandState(Gelaim* gelaim) : GelaimState(gelaim){
}
//------------------------------------------------------------------------------
// fXgN^
GelaimStandState::~GelaimStandState(){
}
//------------------------------------------------------------------------------
// s
//------------------------------------------------------------------------------
// 
void GelaimStandState::initialize(){
	// Aj[VV[PXݒ
	getAnimation()->setSequence(1);
}
//------------------------------------------------------------------------------
// n
void GelaimStandState::finalize(){
}
//------------------------------------------------------------------------------
// s
void GelaimStandState::run(){
	// 萔
	float animationScale = 1.f;

	// Xe[gύX
	if(!isDamaged()){
		if((getRandom().get() % 60) == 0){
			getEnemy()->setState(new GelaimRunState(getGelaim()));
		}else if((getPlayerDistance().getLength() < 15.f) &&
			((getRandom().get() % 120) == 0)){
			getEnemy()->setState(new GelaimAttackState(getGelaim()));
		}
	}

	// ʒuƑx̌vZ
	calcVelocityAndPosition();

	// ̐ݒ
	setDirection(getPlayerDirection());

	// n`RW
	landCollide();

	// `ZbgAbv
	drawSetup(animationScale);
}
//------------------------------------------------------------------------------
