//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * WFC_[WԎ
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Enemy/Gelaim/GelaimBigDamageState.h"
#include "Game/Sound/SoundSystem.h"
#include "Enemy/System/Enemy.h"

#include "Enemy/Gelaim/GelaimDeathState.h"
#include "Enemy/Gelaim/GelaimStandState.h"

//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
GelaimBigDamageState::GelaimBigDamageState(Gelaim* gelaim) :
	GelaimState(gelaim){
}
//------------------------------------------------------------------------------
// fXgN^
GelaimBigDamageState::~GelaimBigDamageState(){
}
//------------------------------------------------------------------------------
// s
//------------------------------------------------------------------------------
// 
void GelaimBigDamageState::initialize(){
	// ̐ݒ
	Vector3 direction = -getDamageDirection();
	direction.y = 0.f;
	setDirection(direction);
	clearDamage();
	// Aj[VV[PXݒ
	getAnimation()->setSequence(5);
	// x̏
	setVelocity(Vector3(0.f, 1.5f, 0.f));
	// GJE^ݒ
	setMatchlessCounter(10);
	// 炷
	getSoundSystem()->play("GelaimBigDamage");
}
//------------------------------------------------------------------------------
// n
void GelaimBigDamageState::finalize(){
}
//------------------------------------------------------------------------------
// s
void GelaimBigDamageState::run(){
	// 萔
	float animationScale = 1.f;

	// Xe[gύX
	if(getRunCounter() == 60){
		if(isDeath()){
			// S
			getEnemy()->setState(new GelaimDeathState(getGelaim()));
		}else{
			// łȂΗ
			getEnemy()->setState(new GelaimStandState(getGelaim()));
		}
	}

	// ʒuƑx̌vZ
	float rate = (1.f - ((float)getRunCounter() / 120.f)) * 0.4f;
	calcVelocityAndPosition(-getDirection() * rate);

	// n`RW
	landCollide();

	// `ZbgAbv
	drawSetup(animationScale);

}
//------------------------------------------------------------------------------
