//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * WFC
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Enemy/Gelaim/Gelaim.h"
#include "Game/System/GameSystem.h"
#include "Game/Rendering/RenderingSystem.h"
#include "Game/Animation/AnimationSystem.h"
#include "Game/Sound/SoundSystem.h"
#include "Load/System/LoadTask.h"
#include "Game/Input/GamePad.h"
#include "Enemy/Gelaim/GelaimStandState.h"

//------------------------------------------------------------------------------
// RXgN^
Gelaim::Gelaim(int health, u_int randomSeed) : Enemy(health, randomSeed){
	String name("Gelaim");
	// f̏
	initializeModel(name, "Front2", "Center", SceneObject::copyMaterial);

	// Aj[V̏
	initializeAnimation(name);

	// RWm[h̏
	initializeCollision(name, 4.f, 6.f);

	// Ԃ̐ݒ
	GelaimState* state = new GelaimStandState(this);
	setState(state);

	// }eÃ_}CY
	BasicMaterial* material =
		getModel()->getMesh(0)->getMaterial()->castBasicMaterial();
	material->setDiffuseColor(Color3f(
		getRandom().getUnsignedFloat(),
		getRandom().getUnsignedFloat(),
		getRandom().getUnsignedFloat()));
	material->setSpecularColor(Color3f(
		getRandom().getUnsignedFloat() + 0.5f,
		getRandom().getUnsignedFloat() + 0.5f,
		getRandom().getUnsignedFloat() + 0.5f));
	material->setAlpha(getRandom().getUnsignedFloat() * 0.5f + 0.5f);

	// 
	getSoundSystem()->play("GelaimGenerate");
}
//------------------------------------------------------------------------------
// fXgN^
Gelaim::~Gelaim(){
}
//------------------------------------------------------------------------------
// [h
void Gelaim::load(SceneNode* enemyNode){
	LoadTask* loadTask = getGameSystem()->getLoadTask();
	// [h^XN̓o^
	loadTask->requestScene(
		"Media/Enemy/Gelaim/Gelaim.bsn", getScene(), enemyNode);
	loadTask->requestAnimation("Media/Enemy/Gelaim/Gelaim.bam",
		getAnimationManager(), getScene());
}
//------------------------------------------------------------------------------
