//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * AUiUԎ
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Enemy/Azalinna/AzalinnaAttackState.h"
#include "Game/Sound/SoundSystem.h"
#include "Enemy/System/Enemy.h"
#include "Stage/System/Stage.h"

#include "Enemy/Azalinna/AzalinnaStandState.h"

//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
AzalinnaAttackState::AzalinnaAttackState(Azalinna* gelaim) : AzalinnaState(gelaim){
}
//------------------------------------------------------------------------------
// fXgN^
AzalinnaAttackState::~AzalinnaAttackState(){
}
//------------------------------------------------------------------------------
// s
//------------------------------------------------------------------------------
// 
void AzalinnaAttackState::initialize(){
	// Aj[VV[PXݒ
	getAnimation()->setSequence(1);
}
//------------------------------------------------------------------------------
// n
void AzalinnaAttackState::finalize(){
	// RW𖳌ɖ߂
	getAttackCollision()->setEnabled(false);
}
//------------------------------------------------------------------------------
// s
void AzalinnaAttackState::run(){
	// 萔
	float animationScale = 1.f;
	float moveXZScale = 0.01f;

	// Xe[gύX
	if(!isDamaged()){
		if(getRunCounter() == 90){
			getEnemy()->setState(new AzalinnaStandState(getAzalinna()));
		}
	}

	// ʒuƑx̌vZ
	calcVelocityAndPosition();
	// ̐ݒ
	setDirection(getPlayerDirection());

	// n`RW
	landCollide();

	// `ZbgAbv
	drawSetup(animationScale);

	// U
	if(getRunCounter() == 50){
		// U炷
		getSoundSystem()->play("AzalinnaAttack");
		getAttackCollision()->setEnabled(true);
	}
	if(getRunCounter() == 80){ getAttackCollision()->setEnabled(false); }
	if(getAttackCollision()->isEnabled()){
		attackCollide(getAttackBone(), Vector3(0.f, -7.5f, 7.5f), 7.5f, 70);
	}

}
//------------------------------------------------------------------------------
