//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * AUi
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Enemy/Azalinna/Azalinna.h"
#include "Game/System/GameSystem.h"
#include "Game/Rendering/RenderingSystem.h"
#include "Game/Animation/AnimationSystem.h"
#include "Game/Sound/SoundSystem.h"
#include "Load/System/LoadTask.h"
#include "Game/Input/GamePad.h"
#include "Enemy/Azalinna/AzalinnaStandState.h"

//------------------------------------------------------------------------------
// RXgN^
Azalinna::Azalinna(int health, u_int randomSeed) : Enemy(health, randomSeed){
	String name("Azalinna");
	// f̏
	initializeModel(name, "Kuki4", "Kuki2", 0);

	// Aj[V̏
	initializeAnimation(name);

	// RWm[h̏
	initializeCollision(name, 5.f, 7.f);

	// Ԃ̐ݒ
	AzalinnaState* state = new AzalinnaStandState(this);
	setState(state);

	// 
	getSoundSystem()->play("AzalinnaGenerate");
}
//------------------------------------------------------------------------------
// fXgN^
Azalinna::~Azalinna(){
}
//------------------------------------------------------------------------------
// [h
void Azalinna::load(SceneNode* enemyNode){
	LoadTask* loadTask = getGameSystem()->getLoadTask();
	// [h^XN̓o^
	loadTask->requestScene(
		"Media/Enemy/Azalinna/Azalinna.bsn", getScene(), enemyNode);
	loadTask->requestAnimation("Media/Enemy/Azalinna/Azalinna.bam",
		getAnimationManager(), getScene());
}
//------------------------------------------------------------------------------
