//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * fobOwbhAbvfBXvCwb_
 * @author Junpee
 */

#ifndef DEBUG_HUD_H_
#define DEBUG_HUD_H_

//------------------------------------------------------------------------------
/**
 * fobOwbhAbvfBXvC
 */
class DebugHUD : public GraphicsDeviceObjectHolder{
friend class PrismaticUmbrella;
public:
	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * ̒ǉ
	 * @param string 
	 */
	static void append(const String& string){
		Assert(instance_ != NULL);
		instance_->topLeft_ += string;
	}

	/**
	 * F̐ݒ
	 * @param color F
	 */
	static void setColor(Color4c color){
		Assert(instance_ != NULL);
		instance_->topLeftColor_ = color;
	}

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * ̐ݒ
	 * @param string 
	 */
	static void setBottomLeft(const String& string){
		Assert(instance_ != NULL);
		instance_->bottomLeft_ = string;
	}

	/**
	 * F̐ݒ
	 * @param color F
	 */
	static void setBottomLeftColor(Color4c color){
		Assert(instance_ != NULL);
		instance_->bottomLeftColor_ = color;
	}

	//--------------------------------------------------------------------------
	// E
	//--------------------------------------------------------------------------
	/**
	 * E㕶̐ݒ
	 * @param string E㕶
	 */
	static void setTopRight(const String& string){
		Assert(instance_ != NULL);
		instance_->topRight_ = string;
	}

	/**
	 * F̐ݒ
	 * @param color F
	 */
	static void setTopRightColor(Color4c color){
		Assert(instance_ != NULL);
		instance_->topRightColor_ = color;
	}

	//--------------------------------------------------------------------------
	// E
	//--------------------------------------------------------------------------
	/**
	 * E̐ݒ
	 * @param string E
	 */
	static void setBottomRight(const String& string){
		Assert(instance_ != NULL);
		instance_->bottomRight_ = string;
	}

	/**
	 * F̐ݒ
	 * @param color F
	 */
	static void setBottomRightColor(Color4c color){
		Assert(instance_ != NULL);
		instance_->bottomRightColor_ = color;
	}

	//--------------------------------------------------------------------------
	// foCXIuWFNg֘A
	//--------------------------------------------------------------------------
	/**
	 * foCXIuWFNg̏
	 *
	 * foCXIuWFNg̏initializeDeviceObjectsI[oCh
	 * @return trueԂ
	 */
	virtual bool initializeGraphicsDeviceObjects();

	/**
	 * foCXIuWFNg̍폜
	 *
	 * foCXIuWFNg̍폜deleteDeviceObjectsI[oCh
	 */
	virtual void deleteGraphicsDeviceObjects();

	/**
	 * foCXIuWFNg̃XgA
	 *
	 * foCXIuWFNg̃XgArestoreDeviceObjectsI[oCh
	 * ̃\bhłŃfoCXXe[gύXƁAftHgXe[gƂȂA
	 * _ZbgAbvɂ̃Xe[g܂B
	 * @return trueԂ
	 */
	virtual bool restoreGraphicsDeviceObjects();

	/**
	 * foCXIuWFNg̖
	 *
	 * foCXIuWFNg̖invalidateDeviceObjectsI[oCh
	 */
	virtual void invalidateGraphicsDeviceObjects();

protected:
	//--------------------------------------------------------------------------
	// An
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param windowHandle EBhEnh
	 */
	static void initialize(HWND windowHandle);

	/**
	 * n
	 */
	static void finalize();

	//--------------------------------------------------------------------------
	// `
	//--------------------------------------------------------------------------
	/**
	 * `
	 */
	static void draw(){
		Assert(instance_ != NULL);
		instance_->drawImplement();
	}

	/**
	 * `
	 */
	virtual void drawImplement();

	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param windowHandle EBhEnh
	 */
	DebugHUD(HWND windowHandle);

	/**
	 * fXgN^
	 */
	virtual ~DebugHUD();

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	DebugHUD(const DebugHUD& copy);

	// Rs[̉B
	void operator =(const DebugHUD& copy);

	//--------------------------------------------------------------------------
	// o
	//--------------------------------------------------------------------------
	// CX^X
	static DebugHUD* instance_;
	// EBhEnh
	HWND windowHandle_;
	// tHg
	ID3DXFont* font_;
	// tHgLq
	D3DXFONT_DESC fontDescription_;
	// 㕶
	String topLeft_;
	// 
	String bottomLeft_;
	// E㕶
	String topRight_;
	// E
	String bottomRight_;
	// F
	Color4c topLeftColor_;
	// F
	Color4c bottomLeftColor_;
	// EF
	Color4c topRightColor_;
	// EF
	Color4c bottomRightColor_;

};

//------------------------------------------------------------------------------
#endif // End of DEBUG_HUD_H_
//------------------------------------------------------------------------------

