//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * fobOwbhAbvfBXvC
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Core/Utility/DebugHUD.h"
#include "Core/System/StringMethod.h" // StdStrcpy

// CX^X
DebugHUD* DebugHUD::instance_ = NULL;

//------------------------------------------------------------------------------
// An
//------------------------------------------------------------------------------
// 
void DebugHUD::initialize(HWND windowHandle){
	Assert(instance_ == NULL);
	instance_ = new DebugHUD(windowHandle);
}
//------------------------------------------------------------------------------
// n
void DebugHUD::finalize(){
	Assert(instance_ != NULL);
	SafeDelete(instance_);
}
//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
DebugHUD::DebugHUD(HWND windowHandle) :
	windowHandle_(windowHandle), font_(NULL),
	topLeftColor_(Color4c::white), bottomLeftColor_(Color4c::white),
	topRightColor_(Color4c::white), bottomRightColor_(Color4c::white){
	// tHgLq
	::memset(&fontDescription_, 0, sizeof(D3DXFONT_DESC));
	fontDescription_.Height = 23;
	fontDescription_.Weight = FW_NORMAL; 
	fontDescription_.Weight = FW_BOLD; 
	fontDescription_.CharSet = SHIFTJIS_CHARSET;
	StdStrcpy(fontDescription_.FaceName, "lr SVbN");
//	StdStrcpy(fontDescription_.FaceName, "lr o SVbN");
	// foCXIuWFNgz_o^
	LampGraphics::addDeviceObjectHolder(this);
}
//------------------------------------------------------------------------------
// fXgN^
DebugHUD::~DebugHUD(){
	// foCXIuWFNgz_o^
	LampGraphics::removeDeviceObjectHolder(this);
}
//------------------------------------------------------------------------------
// `
//------------------------------------------------------------------------------
// `
void DebugHUD::drawImplement(){
	if(font_ == NULL){ return; }
	RECT rect_;
	::GetClientRect(windowHandle_, &rect_);
	int gap = 5;
	rect_.top += gap;
	rect_.bottom -= gap;
	rect_.left += gap * 2;
	rect_.right -= gap * 2;
	RenderingDevice* device = RenderingDevice::getInstance();
	if(!device->beginScene()){ return; }
	// 
	if(!topLeft_.isEmpty()){
		font_->DrawText(NULL, topLeft_.getBytes(), -1, &rect_,
			(DT_LEFT | DT_TOP), topLeftColor_.getARGB());
	}
	// 
	if(!bottomLeft_.isEmpty()){
		font_->DrawText(NULL, bottomLeft_.getBytes(), -1, &rect_,
			(DT_LEFT | DT_BOTTOM | DT_SINGLELINE),
			bottomLeftColor_.getARGB());
	}
	// E
	if(!topRight_.isEmpty()){
		font_->DrawText(NULL, topRight_.getBytes(), -1, &rect_,
			(DT_RIGHT | DT_TOP | DT_SINGLELINE), topRightColor_.getARGB());
	}
	// E
	if(!bottomRight_.isEmpty()){
		font_->DrawText(NULL, bottomRight_.getBytes(), -1, &rect_,
			(DT_RIGHT | DT_BOTTOM | DT_SINGLELINE),
			bottomRightColor_.getARGB());
	}
	device->endScene();
	topLeft_ = bottomLeft_ = topRight_ = bottomRight_ = "";
}
//------------------------------------------------------------------------------
// foCXIuWFNg֘A
//------------------------------------------------------------------------------
// foCXIuWFNg̏
bool DebugHUD::initializeGraphicsDeviceObjects(){
	// tHg
	if(DirectXFailed(D3DXCreateFontIndirect(
		LampGraphics::getDirect3DDevice(), &fontDescription_, &font_))){
		ErrorOut("DebugHUD::initializeGraphicsDeviceObjects() "
			"tHg̍쐬Ɏs܂");
		SafeRelease(font_);
		return false;
	}
	return true;
}
//------------------------------------------------------------------------------
// foCXIuWFNg̍폜
void DebugHUD::deleteGraphicsDeviceObjects(){
	// tHgn
	SafeRelease(font_);
}
//------------------------------------------------------------------------------
// foCXIuWFNg̃XgA
bool DebugHUD::restoreGraphicsDeviceObjects(){
	// tHg
	if(font_ != NULL){
		if(DirectXFailed(font_->OnResetDevice())){
			ErrorOut("DebugHUD::restoreGraphicsDeviceObjects() "
				"tHg̍쐬Ɏs܂");
			SafeRelease(font_);
			return false;
		}
	}
	return true;
}
//------------------------------------------------------------------------------
// foCXIuWFNg̖
void DebugHUD::invalidateGraphicsDeviceObjects(){
	// tHg
	if(font_ != NULL){ font_->OnLostDevice(); }
}
//------------------------------------------------------------------------------
