//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * vY}eBbNAuwb_
 * @author Junpee
 */

#ifndef PRISMATIC_UMBRELLA_H_
#define PRISMATIC_UMBRELLA_H_

class GameSystem;

//------------------------------------------------------------------------------
/**
 * vY}eBbNAu
 */
class PrismaticUmbrella{
public:
	/**
	 * RXgN^
	 * @param instanceHandle CX^Xnh
	 * @param command R}h
	 */
	PrismaticUmbrella(HINSTANCE instanceHandle, const String& command);

	/**
	 * fXgN^
	 */
	virtual ~PrismaticUmbrella();

	/**
	 * s
	 * @return 0Ԃ
	 */
	virtual int execute();

protected:
	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @return ɐtrueԂ
	 */
	virtual bool initialize();

	/**
	 * EBhȄ
	 * @return trueԂ
	 */
	virtual bool initializeWindow();

	//--------------------------------------------------------------------------
	// n
	//--------------------------------------------------------------------------
	/**
	 * n
	 */
	virtual void finalize();

	//--------------------------------------------------------------------------
	// C[v
	//--------------------------------------------------------------------------
	/**
	 * C[v
	 * @return 0Ԃ
	 */
	virtual int mainLoop();

	/**
	 * Q[[v
	 */
	virtual void gameLoop();

	//--------------------------------------------------------------------------
	// EBhEvV[W֘A
	//--------------------------------------------------------------------------
	/**
	 * EBhEvV[W
	 * @param windowHandle EBhEnh
	 * @param message bZ[W
	 * @param wParam wbZ[Wp[^
	 * @param lParam lbZ[Wp[^
	 * @return bZ[WAȏ̏KvȂ0ȊOԂB
	 */
	virtual LRESULT windowProcedure(
		HWND windowHandle, u_int message, WPARAM wParam, LPARAM lParam);

public:
	/**
	 * o^pEBhEvV[W
	 * @param windowHandle EBhEnh
	 * @param message bZ[W
	 * @param wParam wbZ[Wp[^
	 * @param lParam lbZ[Wp[^
	 */
	static LRESULT CALLBACK registrationWindowProcedure(
		HWND windowHandle, u_int message, WPARAM wParam, LPARAM lParam);

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	PrismaticUmbrella(const PrismaticUmbrella& copy);

	// Rs[̉B
	void operator =(const PrismaticUmbrella& copy);

	// Q[VXe
	GameSystem* gameSystem_;

	// CX^Xnh
	HINSTANCE instanceHandle_;
	// EBhEnh
	HWND windowHandle_;
	// O
	String name_;
	// R}h
	String command_;
	// FPSRg[
	FPSController* fpsController_;
	// `FPSv
	FPSMeasurement* drawFPSMeasurement_;
	// Q[FPSv
	FPSMeasurement* gameFPSMeasurement_;
	// EBhE
	int windowWidth_;
	// EBhE
	int windowHeight_;
	// tXN[ŊJn邩
	bool startFullscreen_;

	// CX^X
	static PrismaticUmbrella* instance_;
};

//------------------------------------------------------------------------------
#endif // End of PRISMATIC_UMBRELLA_H_
//------------------------------------------------------------------------------

