//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * vY}eBbNAu
 * @author Junpee
 */

#include "Core/Utility/stdafx.h"
#include "Core/System/PrismaticUmbrella.h"
#include "Game/System/GameSystem.h"
#include "Core/Utility/Performance.h"
#include "Core/Utility/DebugHUD.h"

// CX^X
PrismaticUmbrella* PrismaticUmbrella::instance_ = NULL;

//------------------------------------------------------------------------------
// vOGg|Cg
//------------------------------------------------------------------------------
// C֐
int WINAPI WinMain(
	HINSTANCE instance, HINSTANCE previousInstance, LPSTR command, int show){
	PrismaticUmbrella prismaticUmbrella(instance, command);
	return prismaticUmbrella.execute();
}
//------------------------------------------------------------------------------
// RXgN^
PrismaticUmbrella::PrismaticUmbrella(
	HINSTANCE instanceHandle, const String& command) :
	gameSystem_(NULL), instanceHandle_(instanceHandle), windowHandle_(0),
	name_("PrismaticUmbrella"), command_(command), fpsController_(NULL),
	drawFPSMeasurement_(NULL), gameFPSMeasurement_(NULL), 
//	windowWidth_(640), windowHeight_(480), startFullscreen_(false){
	windowWidth_(640), windowHeight_(480), startFullscreen_(true){
	::ShowCursor(false);///////////////////Ƃ肠
}
//------------------------------------------------------------------------------
// fXgN^
PrismaticUmbrella::~PrismaticUmbrella(){
}
//------------------------------------------------------------------------------
// s
int PrismaticUmbrella::execute(){
	int result = 1;
	// 
	if(initialize()){ result = mainLoop(); }
	// n
	finalize();
	return result;
}
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// 
bool PrismaticUmbrella::initialize(){
	// OtBbNX
	LampGraphics::initialize();
	// EBhȄ
	if(!initializeWindow()){ return false; }

	// fobOwbhAbvfBXvC
	DebugHUD::initialize(windowHandle_);

	// GraphicsfoCX
	GraphicsDeviceEnumeration* enumeration =
		GraphicsDeviceEnumeration::getInstance();
	// obNobt@32bitJ[obt@A24bit[xobt@ɂ
//	enumeration->setMinimumDepthBits(24);
//	enumeration->setMinimumBackBufferAlphaChannelBits(8);
	if(!LampGraphics::initializeDevice(windowHandle_, startFullscreen_)){
		return false;
	}
	// wiNA
	GraphicsDevice::getInstance()->clear(Color4c::gray);

	// LampInput
	if(!LampInput::initialize(instanceHandle_, windowHandle_)){ return false; }

	// LampSound
	if(!LampSound::initialize(windowHandle_)){ return false; }

	// FPSRg[
	fpsController_ = new FPSController();

	// FPSv
	drawFPSMeasurement_ = new FPSMeasurement();
	gameFPSMeasurement_ = new FPSMeasurement();

	// Q[VXe
	gameSystem_ = new GameSystem();

	// CX^X|C^ݒ
	Assert(instance_ == NULL);
	instance_ = this;
	return true;
}
//------------------------------------------------------------------------------
// EBhȄ
bool PrismaticUmbrella::initializeWindow(){
	// EBhEp[^ݒ
	WindowCreator::CreateParameter parameter_;
	parameter_.windowName_ = name_;
	parameter_.instanceHandle_ = instanceHandle_;
	parameter_.windowProcedure_ = registrationWindowProcedure;
	parameter_.createWidth_ = windowWidth_;
	parameter_.createHeight_ = windowHeight_;
	// TCYύX
	parameter_.windowStyle_ ^= WS_THICKFRAME;
	parameter_.windowStyle_ ^= WS_MAXIMIZEBOX;

	// EBhE̍쐬
	windowHandle_ = WindowCreator::create(parameter_);
	if(windowHandle_ == NULL){ return false; }
	return true;
}
//------------------------------------------------------------------------------
// n
//------------------------------------------------------------------------------
// n
void PrismaticUmbrella::finalize(){
	// CX^X|C^NA
	instance_ = NULL;
	// Q[VXen
	SafeDelete(gameSystem_);
	// FPSvn
	SafeDelete(gameFPSMeasurement_);
	SafeDelete(drawFPSMeasurement_);
	// FPSRg[n
	SafeDelete(fpsController_);
	// LampSounďn
	LampSound::finalize();
	// LampInpuťn
	LampInput::finalize();
	// LampOtBNX̌n
	LampGraphics::finalize();
	// fobOwbhAbvfBXvCn
	DebugHUD::finalize();
	// EBhE̔j
	WindowCreator::destroy(windowHandle_);
	// LampRǍn
	LampCore::finalize();
}
//------------------------------------------------------------------------------
// C[v
//------------------------------------------------------------------------------
// C[v
int PrismaticUmbrella::mainLoop(){
	// AvP[VANeBułȂ삳
	// ANeBułȂɓ삳Ȃ悤ɂɂGetMessage()gp
	MSG message;
	bool gotMessage;
	message.message = WM_NULL;
	::PeekMessage(&message, NULL, 0, 0, PM_NOREMOVE);

	// ԂꍇlA[vɓOɓ̓obt@UNA
	LampInput::bufferClear();

	// bZ[W[v
	while(message.message != WM_QUIT){
		// bZ[W
		gotMessage = (PeekMessage(&message, NULL, 0, 0, PM_REMOVE) != 0);
		if(gotMessage){
			TranslateMessage(&message);
			DispatchMessage(&message);
		}else{
			// bZ[W΃Q[s
			gameLoop();
		}
	}
	return 0;
}
//------------------------------------------------------------------------------
// Q[[v
void PrismaticUmbrella::gameLoop(){
	// 1/60bƂɒǉ̓obt@̐s
	// ɂ`t[[gɍEȂQ[xł
	// Q[x1FPSȉɂȂ悤łΉiv[vhߓ͂؂̂Ă
	int inputCount = 0;
	LampInput::waitForInput();
	while(LampInput::hasMoreInput()){
		LampInput::nextInput();
		// s
		gameSystem_->run();
		// Q[FPSv
		Performance::setGameFPS(gameFPSMeasurement_->measurement());
		inputCount++;
		// bԈȏ̒xꂪꍇ͓͂j
		if(inputCount == 60){
			LampInput::bufferClear();
			break;
		}
	}
	// TEh̃v[e[V
	LampSound::presentation();
	// `揀
	gameSystem_->renderSetup();
	// FPS̒Aɂ60FPSȏɂȂȂ
	fpsController_->sleep();
	// OtBbNX̃v[e[V
	GraphicsDevice::getInstance()->presentation();
	// `
	gameSystem_->render();
	// `FPSv
	Performance::setDrawFPS(drawFPSMeasurement_->measurement());
	// fobOwbhAbvfBXvC\
	DebugHUD::draw();
}
//------------------------------------------------------------------------------
// EBhEvV[W֘A
//------------------------------------------------------------------------------
// o^pEBhEvV[W
LRESULT CALLBACK PrismaticUmbrella::registrationWindowProcedure(
	HWND windowHandle, u_int message, WPARAM wParam, LPARAM lParam){
	// OȂftHgvV[Ŵ݂Ă
	if(instance_ == NULL){
		return DefWindowProc(windowHandle, message, wParam, lParam);
	}

	// LampvV[WĂяo
	LRESULT result;
	result = LampCore::windowProcedure(windowHandle, message, wParam, lParam);
	if(result != 0){ return result; }

	// vV[WĂяo
	return instance_->windowProcedure(windowHandle, message, wParam, lParam);
}
//------------------------------------------------------------------------------
// EBhEvV[W
LRESULT PrismaticUmbrella::windowProcedure(
	HWND windowHandle, u_int message, WPARAM wParam, LPARAM lParam){

	// ŌɃftHgEBhEvV[WĂ
	return DefWindowProc(windowHandle, message, wParam, lParam);
}
//------------------------------------------------------------------------------
