<?php 
if ( !defined('KS_P2_AVATAR_SIZE') ) :

define ('KS_P2_AVATAR_SIZE', 32);
define ('KS_P2_AVATAR_SIZE_SMALL', 12);
define ('KS_P2_EXCERPT_LENGTH', 140);

load_theme_textdomain('p2', dirname(__FILE__));
add_filter('template_directory', 'ks_p2_template_directory', 90); // Prevent function.php of PC's P2 theme
add_filter('stylesheet_directory', 'ks_p2_template_directory', 90); // Prevent function.php of PC's P2 theme

function ks_p2_template_directory($directory) {
	global $Ktai_Style;
	return $Ktai_Style->get('template_dir');
}

function ks_comment_content_inline($_comment = NULL, $args = array(), $depth = 0) {
	global $comment, $ks_settings;
	if (isset($_comment)) {
		$comment = $_comment;
	}
	?><dd><?php
	echo ks_p2_get_user_avatar(array( 'user_id' => $comment->user_id, 'email' => get_comment_author_email() ));
	if (get_comment_type() == 'comment') {
		if ($comment->comment_approved == '0') {
			?><em><font color="red"><?php _e('Your comment is awaiting moderation.', 'ktai_style'); ?></font></em><br /><?php 
		}
		edit_comment_link('<font size="-1" color="' . $ks_settings['edit_color'] . '">' . __('Edit') . '</font>', '<img localsrc="104" alt="" />');
		echo mb_strcut(get_comment_excerpt(), 0, KS_P2_EXCERPT_LENGTH);
		comment_reply_link(array_merge(
			array(
			'before' => ' <font size="-1"><img localsrc="149" alt="" />', 
			'after' => '</font>', 
			'reply_before' => '', 
			'reply_text' => '<font color="' . $ks_settings['edit_color'] . '">' . __('Reply') . '</font>', 
			'login_text' => '<font color="' . $ks_settings['edit_color'] . '">' . __('Log in to Reply') . '</font>', 
			), 
			$args, 
			array('depth' => $depth, 'max_depth' => $args['max_depth'])
		));
	} else {
		?><img localsrc="<?php comment_type(68, 112, 112); ?>" alt="" /><?php ks_comment_author_link();
	}
	echo '<br clear="all" />';
}

function ks_comment_content($_comment = NULL, $args = array(), $depth = 0) {
	global $comment, $ks_settings;
	if (isset($_comment)) {
		$comment = $_comment;
		?><hr /><dd><?php
	}
	if (get_comment_type() == 'comment') {
		echo ks_p2_get_user_avatar(array( 'user_id' => $comment->user_id, 'email' => get_comment_author_email() ));
	} else {
		?><img localsrc="<?php comment_type(68, 112, 112); ?>" alt="" /><?php 
	}
	ks_p2_comment_author_link(); ?><img localsrc="46" alt="@ " /><font color="#666666"><?php ks_comment_datetime(); ?></font><?php 
	comment_reply_link(array_merge(
		array(
			'before' => ' <font size="-1"><img localsrc="149" alt="" />', 
			'after' => '</font>', 
			'reply_before' => '', 
			'reply_text' => '<font color="' . $ks_settings['edit_color'] . '">' . __('Reply') . '</font>', 
			'login_text' => '<font color="' . $ks_settings['edit_color'] . '">' . __('Log in to Reply') . '</font>', 
		), 
		$args, 
		array('depth' => $depth, 'max_depth' => $args['max_depth'])
	));
	if ($comment->comment_approved == '0') { ?>
		<div><em><font color="red"><?php _e('Your comment is awaiting moderation.', 'ktai_style'); ?></font></em></div>
	<?php }
	edit_comment_link('<font size="-1" color="' . $ks_settings['edit_color'] . '">' . __('Edit') . '</font>', '<img localsrc="104" alt="" />');
	echo '<br clear="all" />';
	comment_text();
}

function ks_end_comment($_comment = NULL, $args = array(), $depth = 0) {
	?></dd><?php
}

function ks_p2_comment_author_link() {
	global $comment;
	if ($comment->user_id) {
		$user = new WP_User($comment->user_id);
		printf('<a href="%s">%s</a>', get_author_posts_url($comment->user_id, $user->user_nicename), attribute_escape($comment->comment_author));
	} else {
		ks_comment_author_link();
	}
}


function ks_p2_get_user_avatar( $args = '' ) {
	if (! ks_is_flat_rate()) {
		return;
	}
	global $current_user;
	$defaults = array(
		'user_id' => false,
		'email' => $current_user->user_email,
		'size' => KS_P2_AVATAR_SIZE
	);
	$r = wp_parse_args( $args, $defaults );
	extract( $r, EXTR_SKIP );
	if ( !$user_id ) {
		$avatar = get_avatar( $email, $size );
	} else {
		$avatar = get_avatar( $user_id, $size );
	}
	$avatar = str_replace("'", '"', $avatar);
	$avatar = preg_replace('/ (alt|class)="[^"]*"/', '', $avatar);
	$avatar = str_replace(' />', ' style="float:left;margin-right:2px;" align="left" />', $avatar);
	return apply_filters( 'p2_get_user_avatar', $avatar, $r );
}

function ks_p2_get_author_id() {
	global $authordata;
	return apply_filters( 'p2_get_author_id', $authordata->ID );
}

function ks_p2_get_archive_author() {
	if (get_query_var('author_name')) :
		$curauth = get_userdatabylogin(get_query_var('author_name'));
	else :
		$curauth = get_userdata(get_query_var('author'));
	endif;

	return apply_filters( 'p2_get_archive_author', $curauth->display_name );
}

function ks_p2_get_mention_name() {
	global $wp_query;
	$mention_name = $wp_query->query_vars['term'];
	$name_map = p2_get_at_name_map();
	$name = get_usermeta( $name_map["@$mention_name"]['id'], 'display_name' );
	return apply_filters( 'p2_get_mention_name', $name );
	}

function ks_p2_get_discussion_links() {
	global $post;
	$comments = get_comments( array('post_id' => $post->ID) );
	if (! $comments || count($comments) < 1) {
		return '';
	}
	foreach ( $comments as $comment) {
		$unique_commentors[$comment->comment_author_email] = $comment;
	}
	$contents = array();
	foreach ( array_slice($unique_commentors, 0, 3) as $comment ) {
		$contents[] = get_avatar($comment, KS_P2_AVATAR_SIZE_SMALL) . attribute_escape($comment->comment_author);
	}
	return '<img localsrc="86" alt="" />' . __('Discussing: ', 'p2') . implode(__(', ', 'p2'), $contents);
}

function ks_p2_title_from_content( $content ) {

    static $strlen =  null;
    if ( !$strlen ) {
        $strlen = function_exists('mb_strlen')? 'mb_strlen' : 'strlen';
    }
    $max_len = 40;
    $title = $strlen( $content ) > $max_len? wp_html_excerpt( $content, $max_len ) . '...' : $content;
    $title = trim( strip_tags( $title ) );
    $title = str_replace("\n", " ", $title);

    return $title;
}

function ks_p2_new_post() {
	if( 'POST' != $_SERVER['REQUEST_METHOD'] || empty( $_POST['action'] ) || $_POST['action'] != 'post' )
	    return;

	if ( !is_user_logged_in() ) {
		auth_redirect();
	}
	if( !current_user_can( 'publish_posts' ) ) {
		wp_redirect( get_bloginfo( 'url' ) . '/' );
		exit;
	}

	check_admin_referer( 'new-post' );
	global $current_user;
	$user_id		= $current_user->user_id;
	$post_content	= $_POST['posttext'];
	$tags			= $_POST['tags'];
	$post_title = ks_p2_title_from_content( $post_content );
	$post_id = wp_insert_post( array(
		'post_author'	=> $user_id,
		'post_title'	=> $post_title,
		'post_content'	=> $post_content,
		'tags_input'	=> $tags,
		'post_status'	=> 'publish'
	) );
	wp_redirect( get_bloginfo( 'url' ) . '/' );
	exit;
}
add_action( 'template_redirect', 'ks_p2_new_post' );

endif;
?>