/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.xml.parser;

import java.io.Closeable;
import java.io.IOException;
import java.io.PushbackReader;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.koiroha.xml.Xml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Toolkit {
    private static final Logger logger = Logger.getLogger(Toolkit.class.getName());
    private static final Set<String> EMPTY_ELEMENT = new HashSet<String>();
    private static final Map<String, Set<String>> PARENT_RELATION = new HashMap<String, Set<String>>();
    private static final Set<String> TEXT_DECORATION_ELEMENT = new HashSet<String>();
    private static final Pattern PATTERN_ATTRIBUTE = Pattern.compile("([^\\s=]+)\\s*(=?)\\s*(\"[^\"]*\"|'[^']*'|[^\\s]*)");

    private Toolkit() {
    }

    public static boolean isEmptyElement(String uri, String localName, String name) {
        if (localName == null) {
            return EMPTY_ELEMENT.contains(name.toLowerCase());
        }
        return EMPTY_ELEMENT.contains(localName.toLowerCase());
    }

    public static void close(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "fail to close stream", ex);
            }
        }
    }

    public static String format(String id, Object ... args) throws MissingResourceException {
        ResourceBundle res = ResourceBundle.getBundle("org.koiroha.xml.parser.messages");
        String msg = res.getString(id);
        return String.format(msg, args);
    }

    public static boolean streamStartsWith(PushbackReader in, String sequence, boolean ignoreCase) throws IOException {
        assert (sequence.indexOf(65535) < 0 || sequence.indexOf(65535) == sequence.length() - 1) : sequence;
        assert (sequence.indexOf(65534) < 0 || sequence.indexOf(65534) == sequence.length() - 1) : sequence;
        char[] preread = new char[sequence.length()];
        for (int i = 0; i < sequence.length(); ++i) {
            int ch = in.read();
            if (!Toolkit.matches(sequence.charAt(i), ch, ignoreCase)) {
                if (ch >= 0) {
                    in.unread(ch);
                }
                in.unread(preread, 0, i);
                return false;
            }
            preread[i] = (char)ch;
        }
        if (sequence.charAt(sequence.length() - 1) != '\uffff') {
            in.unread(preread);
        } else {
            in.unread(preread, 0, preread.length - 1);
        }
        return true;
    }

    public static boolean matches(char pattern, int ch, boolean ignoreCase) {
        if (pattern == '\u0000') {
            return Xml.isWhitespace(ch);
        }
        if (pattern == '\uffff') {
            return ch < 0;
        }
        if (pattern == '\ufffe') {
            return ch >= 0;
        }
        if (ignoreCase) {
            return Character.toLowerCase(pattern) == Character.toLowerCase((char)ch);
        }
        return pattern == ch;
    }

    public static Element getPreferredParent(Element current, Element elem) {
        Element mover;
        assert (current != null);
        String elemName = Toolkit.getName(elem).toLowerCase();
        Set<String> parentNames = PARENT_RELATION.get(elemName);
        if (parentNames != null) {
            mover = current;
            Node parent = mover.getParentNode();
            while (true) {
                if (parentNames.contains(Toolkit.getName(mover).toLowerCase())) {
                    return mover;
                }
                if (!(parent instanceof Element)) break;
                mover = (Element)parent;
                parent = parent.getParentNode();
            }
        }
        if (elemName.equals("p")) {
            mover = current;
            while (true) {
                String name;
                if (!TEXT_DECORATION_ELEMENT.contains(name = Toolkit.getName(mover).toLowerCase()) && !name.equals(elemName)) {
                    return mover;
                }
                if (!(mover.getParentNode() instanceof Element)) break;
                mover = (Element)mover.getParentNode();
            }
        }
        return current;
    }

    public static String getName(Element elem) {
        String name = elem.getLocalName();
        if (name == null) {
            name = elem.getTagName();
        }
        return name;
    }

    public static Map<String, String> parseAttributesSimply(CharSequence body) {
        HashMap<String, String> attr = new HashMap<String, String>();
        Matcher matcher = PATTERN_ATTRIBUTE.matcher(body);
        while (matcher.find()) {
            String name = matcher.group(1).toLowerCase();
            String equal = matcher.group(2);
            String value = matcher.group(3);
            if (equal.length() == 0) {
                value = name;
            } else {
                if (value.length() >= 2 && value.charAt(0) == value.charAt(value.length() - 1) && (value.charAt(0) == '\"' || value.charAt(0) == '\'')) {
                    value = value.substring(1, value.length() - 1);
                }
                value = Xml.unescape(value);
            }
            attr.put(name, value);
        }
        return attr;
    }

    static {
        String resourceName = "/org/koiroha/xml/parser/html.xml";
        URL url = Toolkit.class.getResource(resourceName);
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(url.toString());
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "fail to read resource: " + resourceName, ex);
            throw new IllegalStateException(ex);
        }
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            NodeList nl = (NodeList)xpath.evaluate("/html-tag/tag", doc, XPathConstants.NODESET);
            for (int i = 0; i < nl.getLength(); ++i) {
                String style;
                Element tag = (Element)nl.item(i);
                String name = tag.getAttribute("name");
                String[] parent = tag.getAttribute("parent").split("\\s+");
                if (parent.length > 0) {
                    PARENT_RELATION.put(name, new HashSet<String>(Arrays.asList(parent)));
                }
                if ((style = tag.getAttribute("style")).equals("empty")) {
                    EMPTY_ELEMENT.add(name);
                    continue;
                }
                if (style.equals("decoration")) {
                    TEXT_DECORATION_ELEMENT.add(name);
                    continue;
                }
                if (style.length() != 0) assert (false) : "unexpected style " + name + ": " + style;
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }
}

