/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.xml.parser;

import java.util.Map;
import org.koiroha.xml.DefaultNamespaceContext;
import org.koiroha.xml.Xml;
import org.koiroha.xml.parser.Toolkit;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Markup {
    private final Markup parent;
    private final String uri;
    private final String localName;
    private final String qName;
    private final AttributesImpl attr = new AttributesImpl();
    private boolean empty;
    private boolean end;
    private final DefaultNamespaceContext namespace;

    public Markup(boolean ns, Markup parent, String qName, Map<String, String> attrs, boolean empty, boolean end) {
        this.parent = parent;
        this.qName = qName;
        this.end = end;
        this.namespace = parent != null && ns ? new DefaultNamespaceContext(parent.namespace) : new DefaultNamespaceContext();
        this.parseAttribute(ns, attrs);
        String prefix = "";
        int sep = qName.indexOf(58);
        if (sep < 0 || !ns) {
            this.localName = qName;
        } else {
            prefix = qName.substring(0, sep);
            this.localName = qName.substring(sep + 1);
        }
        this.uri = this.getNamespaceURI(prefix);
        this.empty = empty || Toolkit.isEmptyElement(this.uri, this.localName, qName);
    }

    public String getUri() {
        return this.uri;
    }

    public String getQName() {
        return this.qName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public AttributesImpl getAttributes() {
        return this.attr;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    public boolean isEnd() {
        return this.end;
    }

    public void setEnd(boolean end) {
        this.end = end;
    }

    public boolean isEndOf(Markup elem) {
        assert (this.isEnd()) : elem;
        return this.getLocalName().equals(elem.getLocalName());
    }

    public boolean isDisusedEnd(Markup context) {
        assert (this.isEnd());
        Markup mover = context;
        while (mover != null) {
            if (this.isEndOf(mover)) {
                return false;
            }
            mover = context.parent;
        }
        return true;
    }

    public Markup getParent() {
        return this.parent;
    }

    public String getNamespaceURI(String prefix) {
        return this.namespace.getNamespaceURI(prefix);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("<");
        if (this.isEnd()) {
            buffer.append('/');
        }
        buffer.append(this.getQName());
        for (int i = 0; i < this.attr.getLength(); ++i) {
            buffer.append(' ');
            buffer.append(this.attr.getQName(i)).append("=\"");
            buffer.append(Xml.escape(this.attr.getValue(i))).append("\"");
        }
        if (!this.isEnd() && this.isEmpty()) {
            buffer.append('/');
        }
        buffer.append('>');
        return buffer.toString();
    }

    private void parseAttribute(boolean ns, Map<String, String> attrs) {
        String value;
        String qName;
        if (ns) {
            for (Map.Entry<String, String> e : attrs.entrySet()) {
                qName = e.getKey();
                value = e.getValue();
                if (qName.equals("xmlns")) {
                    this.namespace.setNamespaceURI("", value);
                    continue;
                }
                if (!qName.startsWith("xmlns:")) continue;
                int sep = qName.indexOf(58);
                String localName = qName.substring(sep + 1);
                this.namespace.setNamespaceURI(localName, value);
            }
        }
        for (Map.Entry<String, String> e : attrs.entrySet()) {
            qName = e.getKey();
            value = e.getValue();
            String localName = qName;
            String uri = "";
            if (ns) {
                int sep = qName.indexOf(58);
                if (sep >= 0) {
                    localName = qName.substring(sep + 1);
                    String prefix = qName.substring(0, sep);
                    uri = this.getNamespaceURI(prefix);
                }
                if (qName.equals("xmlns")) {
                    uri = "http://www.w3.org/2000/xmlns/";
                }
            }
            this.attr.addAttribute(uri, localName, qName, "CDATA", value);
        }
    }
}

