/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.xml.parser;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.SAXParser;
import org.koiroha.xml.parser.HTMLBuilder;
import org.koiroha.xml.parser.HTMLParserFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HTMLDocumentBuilder
extends DocumentBuilder {
    private final Map<String, Boolean> feature = new HashMap<String, Boolean>();
    private final DocumentBuilder builder;
    private EntityResolver entityResolver = null;
    private ErrorHandler errorHandler = null;

    public HTMLDocumentBuilder(DocumentBuilder builder, Map<String, Boolean> feature) {
        this.builder = builder;
        this.feature.putAll(feature);
    }

    public boolean getFeature(String name) {
        Boolean value = this.feature.get(name);
        if (value == null) {
            return false;
        }
        return value;
    }

    @Override
    public DOMImplementation getDOMImplementation() {
        return this.builder.getDOMImplementation();
    }

    @Override
    public boolean isNamespaceAware() {
        return this.builder.isNamespaceAware();
    }

    @Override
    public boolean isValidating() {
        return this.builder.isValidating();
    }

    @Override
    public Document newDocument() {
        return this.builder.newDocument();
    }

    @Override
    public Document parse(InputSource is) throws SAXException, IOException {
        HTMLParserFactory factory = new HTMLParserFactory();
        factory.setNamespaceAware(this.builder.isNamespaceAware());
        factory.setValidating(this.builder.isValidating());
        factory.setXIncludeAware(this.builder.isXIncludeAware());
        factory.setSchema(this.builder.getSchema());
        factory.setLowerCaseName(this.getFeature("http://www.koiroha.org/sax/futures/html/lowercasename"));
        SAXParser parser = factory.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        if (this.errorHandler != null) {
            reader.setErrorHandler(this.errorHandler);
        }
        if (this.entityResolver != null) {
            reader.setEntityResolver(this.entityResolver);
        }
        assert (parser.isNamespaceAware() == this.builder.isNamespaceAware());
        assert (parser.isValidating() == this.builder.isValidating());
        assert (parser.isXIncludeAware() == this.builder.isXIncludeAware());
        HTMLBuilder builder = new HTMLBuilder(this.builder, this.entityResolver, this.errorHandler, this.feature);
        reader.setProperty("http://xml.org/sax/properties/lexical-handler", builder);
        reader.setContentHandler(builder);
        reader.setDTDHandler(builder);
        reader.parse(is);
        return builder.getDocument();
    }

    @Override
    public void setEntityResolver(EntityResolver er) {
        this.entityResolver = er;
    }

    @Override
    public void setErrorHandler(ErrorHandler eh) {
        this.errorHandler = eh;
    }
}

