/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.xml.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.koiroha.xml.parser.LocatorReader;
import org.koiroha.xml.parser.Toolkit;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.LexicalHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXMLReader
implements XMLReader {
    private static final Logger logger = Logger.getLogger(AbstractXMLReader.class.getName());
    private final Map<String, Boolean> feature = new HashMap<String, Boolean>();
    private final Map<String, Object> property = new HashMap<String, Object>();
    private ContentHandler contentHandler = null;
    private DTDHandler dtdHandler = null;
    private EntityResolver entityResolver = null;
    private ErrorHandler errorHandler = null;
    private Map<String, String> entityReference = new HashMap<String, String>();
    private int maxEntityReferenceLength = 0;
    protected LocatorReader in = null;
    private InputStream mustClose = null;

    protected AbstractXMLReader() {
        this.setEntityReference("lt", "<");
        this.setEntityReference("gt", ">");
        this.setEntityReference("amp", "&");
        this.setEntityReference("quot", "\"");
        this.setEntityReference("apos", "'");
    }

    protected AbstractXMLReader(Map<String, Boolean> feature, Map<String, Object> property) {
        this();
        this.feature.putAll(feature);
        this.property.putAll(property);
    }

    @Override
    public boolean getFeature(String name) {
        return this.getFeature(name, false);
    }

    protected boolean getFeature(String name, boolean def) {
        Boolean value = this.feature.get(name);
        if (value == null) {
            return def;
        }
        return value;
    }

    public boolean isNamespaceAware() {
        return this.getFeature("http://xml.org/sax/features/namespaces", false);
    }

    public boolean isValidating() {
        return this.getFeature("http://xml.org/sax/features/validation");
    }

    @Override
    public void setFeature(String name, boolean value) {
        this.feature.put(name, value);
    }

    @Override
    public Object getProperty(String name) {
        return this.property.get(name);
    }

    @Override
    public void setProperty(String name, Object value) {
        logger.finest("setProperty(" + name + "," + value + ")");
        this.property.put(name, value);
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this.dtdHandler = handler;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public LexicalHandler getLexicalHandler() {
        return (LexicalHandler)this.getProperty("http://xml.org/sax/properties/lexical-handler");
    }

    public int getMaxEntityReferenceName() {
        return Math.max(this.maxEntityReferenceLength, "#65535".length());
    }

    public void setEntityReference(String name, String value) {
        this.entityReference.put(name, value);
        this.maxEntityReferenceLength = Math.max(name.length(), this.maxEntityReferenceLength);
    }

    public void removeEntityReference(String name) {
        this.entityReference.remove(name);
        if (name.length() == this.maxEntityReferenceLength) {
            int max = 0;
            for (String n : this.entityReference.keySet()) {
                max = Math.max(n.length(), max);
            }
            this.maxEntityReferenceLength = max;
        }
    }

    public String getEntityReference(String name) {
        if (name.length() < 2 || name.charAt(0) != '#') {
            return this.entityReference.get(name);
        }
        try {
            int ch = -1;
            ch = Character.toLowerCase(name.charAt(1)) == 'x' ? Integer.parseInt(name.substring(2), 16) : Integer.parseInt(name.substring(1));
            if (ch < 0 || ch > 65535) {
                throw new NumberFormatException();
            }
            return String.valueOf((char)ch);
        }
        catch (NumberFormatException numberFormatException) {
            return this.entityReference.get(name);
        }
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        this.parse(new InputSource(systemId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputSource is) throws IOException, SAXException {
        try {
            this.prepareReader(is);
            ContentHandler ch = this.getContentHandler();
            if (ch == null) {
                ch = new DefaultHandler2();
            }
            ch.setDocumentLocator(this.in);
            ch.startDocument();
            this.handleDocument();
            ch.endDocument();
        }
        finally {
            Toolkit.close(this.mustClose);
        }
    }

    protected abstract void handleDocument() throws SAXException, IOException;

    private void prepareReader(InputSource is) throws IOException, SAXException {
        String encoding;
        Reader r = is.getCharacterStream();
        if (r != null) {
            this.in = new LocatorReader(r, is.getPublicId(), is.getSystemId());
            this.in.setEncoding(is.getEncoding());
            return;
        }
        InputStream bin = is.getByteStream();
        if (bin == null) {
            String systemId = is.getSystemId();
            if (systemId == null) {
                throw new IOException("target system-id or stream not specified in InputSource");
            }
            bin = this.mustClose = new URL(systemId).openStream();
        }
        if ((encoding = is.getEncoding()) == null) {
            encoding = "UTF-8";
        }
        this.in = new LocatorReader(new InputStreamReader(bin, encoding), is.getPublicId(), is.getSystemId());
        this.in.setEncoding(encoding);
    }
}

