/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.xml;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Xml {
    private static final Logger logger = Logger.getLogger(Xml.class.getName());
    private static final String FEATURE_PREFIX = "http://xml.org/sax/features/";
    public static final String FEATURE_NAMESPACES = "http://xml.org/sax/features/namespaces";
    public static final String FEATURE_VALIDATION = "http://xml.org/sax/features/validation";
    private static final String PROPERTY_PREFIX = "http://xml.org/sax/properties/";
    public static final String PROPERTY_DOCUMENT_XML_VERSION = "http://xml.org/sax/properties/document-xml-version";
    public static final String PROPERTY_LEXICAL_HANDLER = "http://xml.org/sax/properties/lexical-handler";
    private static final Pattern CHARSET_ATTRIBUTE = Pattern.compile(";\\s*charset\\s*=\\s*[\"']?([^\"'\\s;]*)[\"']?", 2);
    private static final Pattern ENTITY_REFERENCE = Pattern.compile("&([^;&]*);");

    private Xml() {
    }

    public static boolean isWhitespace(int ch) {
        return ch == 32 || ch == 9 || ch == 13 || ch == 10;
    }

    public static String escape(String text) {
        StringBuilder buffer = new StringBuilder(text.length());
        block10: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '<': {
                    buffer.append("&lt;");
                    continue block10;
                }
                case '>': {
                    buffer.append("&gt;");
                    continue block10;
                }
                case '&': {
                    buffer.append("&amp;");
                    continue block10;
                }
                case '\"': {
                    buffer.append("&quot;");
                    continue block10;
                }
                case '\'': {
                    buffer.append("&apos;");
                    continue block10;
                }
                case '\n': {
                    buffer.append('\n');
                    continue block10;
                }
                case '\t': {
                    buffer.append('\t');
                    continue block10;
                }
                case '\r': {
                    buffer.append('\n');
                    if (i + 1 >= text.length() || text.charAt(i + 1) != '\n') continue block10;
                    ++i;
                    continue block10;
                }
                default: {
                    if (Character.isDefined(ch) && !Character.isISOControl(ch)) {
                        buffer.append(ch);
                        continue block10;
                    }
                    buffer.append("&#" + ch + ";");
                }
            }
        }
        return buffer.toString();
    }

    public static String unescape(String text) {
        StringBuilder buffer = new StringBuilder(text.length());
        Matcher matcher = ENTITY_REFERENCE.matcher(text);
        int begin = 0;
        while (matcher.find()) {
            int end = matcher.start();
            if (begin != end) {
                buffer.append(text, begin, end);
            }
            begin = matcher.end();
            String name = matcher.group(1);
            if (name.equals("amp")) {
                buffer.append('&');
                continue;
            }
            if (name.equals("lt")) {
                buffer.append('<');
                continue;
            }
            if (name.equals("gt")) {
                buffer.append('>');
                continue;
            }
            if (name.equals("quot")) {
                buffer.append('\"');
                continue;
            }
            if (name.equals("apos")) {
                buffer.append('\'');
                continue;
            }
            if (name.length() > 1 && name.charAt(0) == '#') {
                boolean hex = name.length() > 2 && Character.toLowerCase(name.charAt(1)) == 'x';
                int ch = 0;
                try {
                    ch = hex ? Integer.parseInt(name.substring(2), 16) : Integer.parseInt(name.substring(1), 10);
                    if (ch < 0 || ch > 65535) {
                        throw new NumberFormatException(String.valueOf(ch));
                    }
                    buffer.append((char)ch);
                }
                catch (NumberFormatException ex) {
                    logger.fine("invalid number entity reference: &" + name + ";");
                    buffer.append('&').append(name).append(';');
                }
                continue;
            }
            logger.fine("unrecognized entity character reference: &" + name + ";");
            buffer.append('&').append(name).append(';');
        }
        if (begin != text.length()) {
            buffer.append(text, begin, text.length());
        }
        return buffer.toString();
    }

    public static Charset getCharset(String contentType) {
        logger.finest("getCharset(" + contentType + ")");
        Matcher matcher = CHARSET_ATTRIBUTE.matcher(contentType);
        if (!matcher.find()) {
            logger.finest("no charset specified: " + contentType);
            return null;
        }
        String charset = matcher.group(1);
        boolean supported = false;
        try {
            supported = Charset.isSupported(charset);
        }
        catch (IllegalCharsetNameException ex) {
            // empty catch block
        }
        if (!supported) {
            logger.finest("unsupported charset specified: " + charset + ": " + contentType);
            return null;
        }
        logger.finest("charset retrieved: " + charset + ": " + contentType);
        return Charset.forName(charset);
    }
}

