/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.xml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNamespaceContext
implements NamespaceContext,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(DefaultNamespaceContext.class.getName());
    private final NamespaceContext parent;
    private final Map<String, String> namespace = new HashMap<String, String>();

    public DefaultNamespaceContext() {
        this(null);
    }

    public DefaultNamespaceContext(NamespaceContext parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNamespaceURI(String prefix, String namespaceURI) throws IllegalArgumentException {
        logger.finest("setNamespaceURI(" + prefix + "," + namespaceURI + ")");
        if (prefix == null || namespaceURI == null) {
            throw new IllegalArgumentException("prefix or namespace-uri is null");
        }
        if (prefix.equals("xml") && !namespaceURI.equals("http://www.w3.org/XML/1998/namespace") || prefix.equals("xmlns") && !namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
            throw new IllegalArgumentException("specified prefix is reserved: " + prefix);
        }
        Map<String, String> map = this.namespace;
        synchronized (map) {
            this.namespace.put(prefix, namespaceURI);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (prefix.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        Map<String, String> map = this.namespace;
        synchronized (map) {
            if (this.namespace.containsKey(prefix)) {
                return this.namespace.get(prefix);
            }
        }
        if (this.parent != null) {
            return this.parent.getNamespaceURI(prefix);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException();
        }
        if (namespaceURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        Map<String, String> map = this.namespace;
        synchronized (map) {
            for (Map.Entry<String, String> e : this.namespace.entrySet()) {
                if (!namespaceURI.equals(e.getValue())) continue;
                return e.getKey();
            }
        }
        if (this.parent != null) {
            return this.parent.getPrefix(namespaceURI);
        }
        if (namespaceURI.equals("")) {
            return "";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException();
        }
        if (namespaceURI.equals("http://www.w3.org/XML/1998/namespace")) {
            ArrayList<String> col = new ArrayList<String>();
            col.add("xml");
            return col.iterator();
        }
        if (namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
            ArrayList<String> col = new ArrayList<String>();
            col.add("xmlns");
            return col.iterator();
        }
        HashSet<String> prefix = new HashSet<String>();
        Map<String, String> map = this.namespace;
        synchronized (map) {
            for (Map.Entry<String, String> e : this.namespace.entrySet()) {
                if (!namespaceURI.equals(e.getValue())) continue;
                prefix.add(e.getKey());
            }
        }
        if (this.parent != null) {
            Iterator<String> it = this.parent.getPrefixes(namespaceURI);
            while (it.hasNext()) {
                prefix.add(it.next());
            }
        }
        return prefix.iterator();
    }
}

