/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.kwt.xsl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

final class XSLErrorHandler
extends DefaultHandler {
    private static final Logger logger = Logger.getLogger(XSLErrorHandler.class.getName());
    private final Level level;
    private final boolean failOnError;
    private final String systemId;

    public XSLErrorHandler(String string, Level level, boolean bl) {
        this.systemId = string;
        this.level = level;
        this.failOnError = bl;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        logger.finest("warning(" + sAXParseException + ")");
        logger.log(this.level, this.getMessage(sAXParseException));
        if (this.failOnError) {
            throw sAXParseException;
        }
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        logger.finest("error(" + sAXParseException + ")");
        logger.log(this.level, this.getMessage(sAXParseException));
        if (this.failOnError) {
            throw sAXParseException;
        }
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        logger.finest("fatalError(" + sAXParseException + ")");
        logger.log(this.level, this.getMessage(sAXParseException));
        if (this.failOnError) {
            throw sAXParseException;
        }
    }

    private String getMessage(SAXParseException sAXParseException) {
        StringBuilder stringBuilder = new StringBuilder();
        if (sAXParseException.getSystemId() != null) {
            stringBuilder.append(sAXParseException.getSystemId());
        } else {
            stringBuilder.append(this.systemId);
        }
        if (sAXParseException.getLineNumber() > 0) {
            stringBuilder.append('(').append(sAXParseException.getLineNumber());
            if (sAXParseException.getColumnNumber() > 0) {
                stringBuilder.append(',').append(sAXParseException.getColumnNumber());
            }
            stringBuilder.append(')');
        }
        stringBuilder.append(": ").append(sAXParseException.getMessage());
        return stringBuilder.toString();
    }
}

