/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.kwt.xsl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.koiroha.kwt.xsl.Config;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SchemaCatalog
implements EntityResolver,
LSResourceResolver,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(SchemaCatalog.class.getName());
    public static final String NAMESPACE_URI = "http://www.koiroha.org/xmlns/kwt/schema-catalog";
    private final Map<String, URI> publicId = new HashMap<String, URI>();
    private final Map<String, URI> systemId = new HashMap<String, URI>();
    private final Map<String, URI> namespace = new HashMap<String, URI>();
    private final File dir;

    public SchemaCatalog(URI uRI, File file) throws ServletException {
        this.dir = file;
        if (uRI == null) {
            logger.finer("no schema-catalog specified");
            return;
        }
        try {
            String string;
            String string2;
            String string3;
            Element element;
            int n;
            logger.finest("loading schema catalog: " + uRI);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(uRI.toURL().toString());
            NodeList nodeList = document.getElementsByTagNameNS(NAMESPACE_URI, "dtd");
            for (n = 0; n < nodeList.getLength(); ++n) {
                element = (Element)nodeList.item(n);
                string3 = element.getAttribute("location");
                string2 = element.getAttribute("public-id");
                if (string2.length() > 0) {
                    logger.finest("catalog public-id: " + string2 + "=" + uRI.resolve(string3));
                    this.publicId.put(string2, uRI.resolve(string3));
                }
                if ((string = element.getAttribute("system-id")).length() <= 0) continue;
                logger.finest("catalog system-id: " + string + "=" + uRI.resolve(string3));
                this.systemId.put(string, uRI.resolve(string3));
            }
            nodeList = document.getElementsByTagNameNS(NAMESPACE_URI, "xml-schema");
            for (n = 0; n < nodeList.getLength(); ++n) {
                element = (Element)nodeList.item(n);
                string3 = element.getAttribute("location");
                string2 = element.getAttribute("namespace-uri");
                if (string2.length() > 0) {
                    logger.finest("catalog namespace uri: " + string2 + "=" + uRI.resolve(string3));
                    this.namespace.put(string2, uRI.resolve(string3));
                }
                if ((string = element.getAttribute("system-id")).length() <= 0) continue;
                logger.finest("catalog system-id: " + string + "=" + uRI.resolve(string3));
                this.systemId.put(string, uRI.resolve(string3));
            }
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
    }

    public Schema getXmlSchema(String string) throws IOException, SAXException {
        if (!this.namespace.containsKey(string)) {
            return null;
        }
        URI uRI = this.namespace.get(string);
        return this.loadXmlSchema(uRI, uRI.toString());
    }

    public Schema getXmlSchema(String string, String string2) throws IOException, SAXException {
        File file;
        URI uRI = null;
        if (this.namespace.containsKey(string)) {
            uRI = this.namespace.get(string);
        }
        if (uRI == null && (file = this.getLocalFile(string2)) != null) {
            uRI = file.toURI();
        }
        if (uRI == null) {
            return null;
        }
        return this.loadXmlSchema(uRI, string2);
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws IOException {
        logger.finest("resolveEntity(" + string + "," + string2 + ")");
        if (string2 != null && string2.toLowerCase().startsWith("file:/")) {
            logger.finest("skip local file");
            return null;
        }
        InputSource inputSource = new InputSource();
        inputSource.setPublicId(string);
        inputSource.setSystemId(string2);
        URI uRI = this.publicId.get(string);
        if (uRI == null) {
            uRI = this.systemId.get(string2);
        }
        if (uRI == null) {
            File file = this.getLocalFile(string2);
            if (file == null) {
                return null;
            }
            uRI = file.toURI();
        }
        inputSource.setByteStream(SchemaCatalog.getInputStream(uRI.toURL()));
        return inputSource;
    }

    @Override
    public LSInput resolveResource(String string, String string2, String string3, String string4, String string5) {
        logger.finest("resolveResource(" + string + "," + string2 + "," + string3 + "," + string4 + "," + string5 + ")");
        if (string4 != null && string4.toLowerCase().startsWith("file:/")) {
            logger.finest("skip local file");
            return null;
        }
        File file = this.getLocalFile(string4);
        if (file == null) {
            return null;
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            DOMImplementationLS dOMImplementationLS = (DOMImplementationLS)((Object)documentBuilder.getDOMImplementation());
            LSInput lSInput = dOMImplementationLS.createLSInput();
            lSInput.setPublicId(string3);
            lSInput.setSystemId(string4);
            lSInput.setByteStream(new FileInputStream(file));
            return lSInput;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Schema loadXmlSchema(URI uRI, String string) throws IOException, SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setResourceResolver(this);
        Schema schema = null;
        InputStream inputStream = null;
        try {
            inputStream = SchemaCatalog.getInputStream(uRI.toURL());
            StreamSource streamSource = new StreamSource(inputStream);
            if (string != null) {
                streamSource.setSystemId(string);
            }
            schema = schemaFactory.newSchema(streamSource);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                logger.warning("fail to close: " + iOException);
            }
        }
        return schema;
    }

    private File getLocalFile(String string) {
        String string2 = SchemaCatalog.toSafe(string);
        File file = new File(Config.getCacheDirectory(this.dir, "schema"), string2);
        if (file.isFile()) {
            return file;
        }
        try {
            this.save(string, file);
        }
        catch (IOException iOException) {
            logger.warning("fail to retrieve resource: " + string + ": " + iOException);
            return null;
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(String string, File file) throws IOException {
        logger.finest("save(" + string + "," + file + ")");
        if (!file.getCanonicalPath().startsWith(this.dir.getCanonicalPath())) {
            throw new IllegalStateException("invalid file location to write: " + file);
        }
        file.getParentFile().mkdirs();
        URL uRL = new URL(string);
        FileOutputStream fileOutputStream = null;
        InputStream inputStream = null;
        byte[] byArray = new byte[1024];
        try {
            int n;
            inputStream = SchemaCatalog.getInputStream(uRL);
            fileOutputStream = new FileOutputStream(file);
            while ((n = inputStream.read(byArray)) >= 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            catch (IOException iOException) {}
        }
        logger.fine("save resource to local: " + file.getName() + " (" + file.length() / 1024L + "kB)");
    }

    private static final InputStream getInputStream(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 5.1)");
        uRLConnection.setAllowUserInteraction(false);
        return uRLConnection.getInputStream();
    }

    private static final String toSafe(String string) {
        if (string.startsWith("http://")) {
            string = string.substring("http://".length());
        }
        byte[] byArray = string.getBytes(Charset.forName("UTF-8"));
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (by >= 97 && by <= 122 || by >= 65 && by <= 90 || by >= 48 && by <= 57 || by == 45 || by == 46) {
                stringBuilder.append((char)by);
                continue;
            }
            if (by == 95) {
                stringBuilder.append("__");
                continue;
            }
            if (by == 32) {
                stringBuilder.append("_+");
                continue;
            }
            if (by == 47) {
                stringBuilder.append("_");
                continue;
            }
            stringBuilder.append('_');
            stringBuilder.append(Character.forDigit(by >> 4 & 0xF, 16));
            stringBuilder.append(Character.forDigit(by >> 0 & 0xF, 16));
        }
        String string2 = stringBuilder.toString();
        logger.finest(string + " -> " + string2);
        return stringBuilder.toString();
    }
}

