/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.kwt.xsl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

final class DependencyCapture
extends DefaultHandler {
    private static final Logger logger = Logger.getLogger(DependencyCapture.class.getName());
    private final String namespaceUri;
    private final Set<String> localNames = new HashSet<String>();
    private final URI baseUri;
    private final Set<URI> dependUri;

    public DependencyCapture(URI uRI, Set<URI> set, String string, String ... stringArray) {
        this.baseUri = uRI;
        this.dependUri = set;
        this.namespaceUri = string;
        this.localNames.addAll(Arrays.asList(stringArray));
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (!this.namespaceUri.equals(string)) {
            return;
        }
        if (this.localNames.contains(string2) && attributes.getIndex("href") >= 0) {
            String string4 = attributes.getValue("href");
            try {
                URI uRI = new URI(string4);
                if (!uRI.isAbsolute()) {
                    uRI = this.baseUri.resolve(uRI);
                }
                this.dependUri.add(uRI);
            }
            catch (URISyntaxException uRISyntaxException) {
                logger.finest("unrecognized uri: " + string4 + "; " + uRISyntaxException);
            }
        }
    }
}

