/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.kwt.xsl.handler;

import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.koiroha.kwt.xsl.Dependency;
import org.koiroha.kwt.xsl.TransformationHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class WhitespaceStripBetweenKanjiHandler
implements TransformationHandler {
    private static final Set<String> DEFAULT_IGNOREABLE = new HashSet<String>();

    @Override
    public Document process(Document document, URI uRI, URI uRI2, Collection<Dependency> collection) {
        WhitespaceStripBetweenKanjiHandler.strip(document.getDocumentElement(), false);
        return document;
    }

    private static void strip(Element element, boolean bl) {
        String string = element.getAttribute("xml:space");
        string = element.hasAttributeNS("http://www.w3.org/XML/1998/namespace", "space") ? element.getAttributeNS("http://www.w3.org/XML/1998/namespace", "space") : element.getAttribute("xml:space");
        if (string.equals("preserved")) {
            bl = true;
        } else if (string.equals("default")) {
            bl = false;
        }
        String string2 = "http://www.w3.org/1999/xhtml";
        if ((element.getNamespaceURI() == null || element.getNamespaceURI().equals(string2)) && DEFAULT_IGNOREABLE.contains(element.getTagName().toLowerCase())) {
            return;
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!bl && node.getNodeType() == 3) {
                element.replaceChild(WhitespaceStripBetweenKanjiHandler.getStripText((Text)node), node);
                continue;
            }
            if (!(node instanceof Element)) continue;
            WhitespaceStripBetweenKanjiHandler.strip((Element)node, bl);
        }
    }

    private static Text getStripText(Text text) {
        String string = text.getData();
        StringBuilder stringBuilder = new StringBuilder(string);
        int n = 1;
        while (n + 1 < stringBuilder.length()) {
            char c = stringBuilder.charAt(n);
            if (WhitespaceStripBetweenKanjiHandler.isWhitespace(c) && WhitespaceStripBetweenKanjiHandler.isKanji(stringBuilder.charAt(n - 1))) {
                int n2 = n + 1;
                while (n2 + 1 < stringBuilder.length() && WhitespaceStripBetweenKanjiHandler.isWhitespace(stringBuilder.charAt(n2))) {
                    ++n2;
                }
                char c2 = stringBuilder.charAt(n2);
                if (WhitespaceStripBetweenKanjiHandler.isKanji(c2)) {
                    stringBuilder.delete(n, n2);
                    --n;
                }
            }
            ++n;
        }
        return text.getOwnerDocument().createTextNode(stringBuilder.toString());
    }

    private static boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    private static boolean isKanji(char c) {
        return c >= '\u0080';
    }

    static {
        DEFAULT_IGNOREABLE.add("pre");
        DEFAULT_IGNOREABLE.add("xmp");
        DEFAULT_IGNOREABLE.add("style");
        DEFAULT_IGNOREABLE.add("script");
        DEFAULT_IGNOREABLE.add("textarea");
        DEFAULT_IGNOREABLE.add("plaintext");
    }
}

