/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.kwt.xsl.handler;

import java.net.URI;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathFactory;
import org.koiroha.kwt.xsl.Dependency;
import org.koiroha.kwt.xsl.TransformationHandler;
import org.koiroha.kwt.xsl.formatter.SourceFormatter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SourceFormatHandler
implements TransformationHandler {
    private static final Logger logger = Logger.getLogger(SourceFormatHandler.class.getName());
    private final Map<String, SourceFormatter> formatter = new HashMap<String, SourceFormatter>();

    public SourceFormatHandler() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.koiroha.kwt.xsl.formatter.formatter");
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            String string2 = resourceBundle.getString(string);
            try {
                SourceFormatter sourceFormatter = (SourceFormatter)Class.forName(string2).newInstance();
                this.addFormatter(string, sourceFormatter);
            }
            catch (Exception exception) {
                throw new IllegalStateException("fail to instantiate source formatter: " + string2, exception);
            }
        }
    }

    public void addFormatter(String string, SourceFormatter sourceFormatter) {
        this.formatter.put(string, sourceFormatter);
    }

    @Override
    public Document process(Document document, URI uRI, URI uRI2, Collection<Dependency> collection) {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        try {
            NodeList nodeList = (NodeList)xPath.evaluate("//*[starts-with(@class,'code ')]", document, XPathConstants.NODESET);
            logger.finest(nodeList.getLength() + " elements matches to format as source code");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                element.normalize();
                String string = element.getAttribute("class");
                StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\r\n");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    SourceFormatter sourceFormatter = this.formatter.get(string2);
                    if (sourceFormatter != null) {
                        logger.finest("calling formatter: " + sourceFormatter.getClass().getName());
                        sourceFormatter.format(element);
                        continue;
                    }
                    logger.finest("formatter undefined: " + string2);
                }
            }
        }
        catch (XPathException xPathException) {
            throw new IllegalStateException(xPathException);
        }
        return document;
    }
}

