/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.kwt.xsl.formatter;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.koiroha.kwt.xsl.formatter.SourceFormatter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlFormatter
extends SourceFormatter {
    @Override
    public void format(PushbackReader pushbackReader, Element element) throws IOException {
        int n;
        Document document = element.getOwnerDocument();
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = pushbackReader.read()) >= 0) {
            String string;
            if (n != 60) {
                stringBuilder.append((char)n);
                continue;
            }
            String string2 = stringBuilder.toString();
            stringBuilder.setLength(0);
            element.appendChild(document.createTextNode(string2));
            n = pushbackReader.read();
            if (n < 0) {
                stringBuilder.append('<');
                break;
            }
            if (n == 63) {
                string = "<?" + this.read(pushbackReader, "?>");
                this.parseProcessingInstruction(string, element);
                continue;
            }
            if (n != 33) {
                string = "<" + (char)n + this.read(pushbackReader, ">");
                this.parseElement(string, element);
                continue;
            }
            n = pushbackReader.read();
            if (n == 45) {
                string = "<!-" + this.read(pushbackReader, "-->");
                this.parseComment(string, element);
                continue;
            }
            if (n == 91) {
                string = "<![" + this.read(pushbackReader, "]]>");
                this.parseCDataSection(string, element);
                continue;
            }
            element.appendChild(document.createTextNode("<!" + (char)n));
        }
        element.appendChild(document.createTextNode(stringBuilder.toString()));
    }

    private void parseElement(String string, Element element) {
        Document document = element.getOwnerDocument();
        if (string.matches("<[/\\?]?[^\\s/>]\\s*[/\\?]?>")) {
            Element element2 = this.createElement(document, element.getNamespaceURI(), "span");
            element2.setAttribute("class", "element");
            element2.appendChild(document.createTextNode(string));
            element.appendChild(element2);
            return;
        }
        Pattern pattern = Pattern.compile("(<[/\\?]?[^\\s/\\?>]+)(\\s*)");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.lookingAt()) {
            element.appendChild(document.createTextNode(string));
            return;
        }
        Object object = matcher.group(0);
        Object object2 = matcher.group(1);
        Object object3 = this.createElement(document, element.getNamespaceURI(), "span");
        object3.setAttribute("class", "element");
        object3.appendChild(document.createTextNode((String)object2));
        element.appendChild((Node)object3);
        Object object4 = matcher.group(2);
        element.appendChild(document.createTextNode((String)object4));
        string = string.substring(((String)object).length());
        object = Pattern.compile("([^\\s/\\?>]+)(\\s*=\\s*)(['\"][^\"]*['\"])(\\s*)");
        while (!(string.length() <= 0 || string.equals("/>") || string.equals("?>") || string.equals(">"))) {
            matcher = ((Pattern)object).matcher(string);
            if (matcher.lookingAt()) {
                object2 = matcher.group(0);
                object3 = matcher.group(1);
                object4 = this.createElement(document, element.getNamespaceURI(), "span");
                object4.setAttribute("class", "attribute-name");
                object4.appendChild(document.createTextNode((String)object3));
                element.appendChild((Node)object4);
                String string2 = matcher.group(2);
                element.appendChild(document.createTextNode(string2));
                String string3 = matcher.group(3);
                object4 = this.createElement(document, element.getNamespaceURI(), "span");
                object4.setAttribute("class", "attribute-value");
                object4.appendChild(document.createTextNode(string3));
                element.appendChild((Node)object4);
                String string4 = matcher.group(4);
                element.appendChild(document.createTextNode(string4));
                string = string.substring(((String)object2).length());
                continue;
            }
            element.appendChild(document.createTextNode(string));
            return;
        }
        object2 = this.createElement(document, element.getNamespaceURI(), "span");
        object2.setAttribute("class", "element");
        object2.appendChild(document.createTextNode(string));
        element.appendChild((Node)object2);
    }

    private void parseProcessingInstruction(String string, Element element) {
        String string2;
        Document document = element.getOwnerDocument();
        Pattern pattern = Pattern.compile("(<\\?[^\\s\\?>]+)([^\\?>]*)\\?>");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            string2 = matcher.group(1);
            if (string2.equals("<?xml") || string2.equals("<?xml-stylesheet")) {
                this.parseElement(string, element);
                return;
            }
        } else {
            element.appendChild(document.createTextNode(string));
            return;
        }
        Element element2 = this.createElement(document, element.getNamespaceURI(), "span");
        element2.setAttribute("class", "element");
        element2.appendChild(document.createTextNode(string2));
        element.appendChild(element2);
        String string3 = matcher.group(2);
        element.appendChild(document.createTextNode(string3));
        element2 = this.createElement(document, element.getNamespaceURI(), "span");
        element2.setAttribute("class", "element");
        element2.appendChild(document.createTextNode("?>"));
        element.appendChild(element2);
    }

    private void parseCDataSection(String string, Element element) {
        Document document = element.getOwnerDocument();
        Pattern pattern = Pattern.compile("<!\\[([a-zA-Z]+)\\[(.*)\\]\\]>", 32);
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            element.appendChild(document.createTextNode(string));
            return;
        }
        String string2 = matcher.group(1);
        Element element2 = this.createElement(document, element.getNamespaceURI(), "span");
        element2.setAttribute("class", "element");
        element2.appendChild(document.createTextNode("<![" + string2 + "["));
        element.appendChild(element2);
        String string3 = matcher.group(2);
        element.appendChild(document.createTextNode(string3));
        element2 = this.createElement(document, element.getNamespaceURI(), "span");
        element2.setAttribute("class", "element");
        element2.appendChild(document.createTextNode("]]>"));
        element.appendChild(element2);
    }

    private void parseComment(String string, Element element) {
        Document document = element.getOwnerDocument();
        Element element2 = this.createElement(document, element.getNamespaceURI(), "span");
        element2.setAttribute("class", "comment");
        element2.appendChild(document.createTextNode(string));
        element.appendChild(element2);
    }

    private String read(Reader reader, String string) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = reader.read()) >= 0) {
            stringBuilder.append((char)n);
            if (!stringBuilder.toString().endsWith(string)) continue;
            break;
        }
        return stringBuilder.toString();
    }

    private Element createElement(Document document, String string, String string2) {
        if (string != null) {
            return document.createElementNS(string, string2);
        }
        return document.createElement(string2);
    }
}

