/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.kwt.xsl.formatter;

import java.io.IOException;
import java.io.PushbackReader;
import java.util.HashSet;
import java.util.Set;
import org.koiroha.kwt.xsl.formatter.CStyleFormatter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JavaFormatter
extends CStyleFormatter {
    private static final Set<String> KEYWORD = new HashSet<String>();

    @Override
    public void format(PushbackReader pushbackReader, Element element) throws IOException {
        int n;
        Document document = element.getOwnerDocument();
        String string = element.getNamespaceURI();
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = pushbackReader.read()) >= 0) {
            Object object;
            if (Character.isJavaIdentifierStart(n)) {
                String string2 = (char)n + this.readIdentifier(pushbackReader);
                object = this.createElement(document, string, "span");
                if (KEYWORD.contains(string2)) {
                    object.setAttribute("class", "keyword");
                } else {
                    object.setAttribute("class", "identifier");
                }
                element.appendChild(document.createTextNode(stringBuilder.toString()));
                element.appendChild((Node)object);
                object.appendChild(document.createTextNode(string2));
                stringBuilder.setLength(0);
                continue;
            }
            if (n == 39 || n == 34) {
                String string3 = this.readLiteral(pushbackReader, (char)n);
                object = this.createElement(document, string, "span");
                if (n == 39) {
                    object.setAttribute("class", "literal character");
                } else {
                    object.setAttribute("class", "literal string");
                }
                element.appendChild(document.createTextNode(stringBuilder.toString()));
                element.appendChild((Node)object);
                object.appendChild(document.createTextNode(string3));
                stringBuilder.setLength(0);
                continue;
            }
            if (n == 47) {
                Element element2;
                int n2 = pushbackReader.read();
                if (n2 == 47) {
                    object = "//" + this.readLineComment(pushbackReader);
                    element2 = this.createElement(document, string, "span");
                    element2.setAttribute("class", "comment line");
                    element.appendChild(document.createTextNode(stringBuilder.toString()));
                    element.appendChild(element2);
                    element2.appendChild(document.createTextNode((String)object));
                    stringBuilder.setLength(0);
                    continue;
                }
                if (n2 == 42) {
                    object = "/*" + this.readBlockComment(pushbackReader);
                    element2 = this.createElement(document, string, "span");
                    if (((String)object).startsWith("/**")) {
                        element2.setAttribute("class", "comment javadoc");
                    } else {
                        element2.setAttribute("class", "comment block");
                    }
                    element.appendChild(document.createTextNode(stringBuilder.toString()));
                    element.appendChild(element2);
                    element2.appendChild(document.createTextNode((String)object));
                    stringBuilder.setLength(0);
                    continue;
                }
                pushbackReader.unread(n2);
            }
            if (n == 64) {
                String string4 = '@' + this.readIdentifier(pushbackReader);
                object = this.createElement(document, string, "span");
                object.setAttribute("class", "annotation");
                element.appendChild(document.createTextNode(stringBuilder.toString()));
                element.appendChild((Node)object);
                object.appendChild(document.createTextNode(string4));
                stringBuilder.setLength(0);
                continue;
            }
            stringBuilder.append((char)n);
        }
        element.appendChild(document.createTextNode(stringBuilder.toString()));
    }

    private Element createElement(Document document, String string, String string2) {
        if (string != null) {
            return document.createElementNS(string, string2);
        }
        return document.createElement(string2);
    }

    private String readIdentifier(PushbackReader pushbackReader) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = pushbackReader.read()) >= 0) {
            if (stringBuilder.length() > 0 && !Character.isJavaIdentifierPart(n)) {
                pushbackReader.unread(n);
                break;
            }
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    static {
        KEYWORD.add("abstract");
        KEYWORD.add("boolean");
        KEYWORD.add("break");
        KEYWORD.add("byte");
        KEYWORD.add("case");
        KEYWORD.add("catch");
        KEYWORD.add("char");
        KEYWORD.add("class");
        KEYWORD.add("const");
        KEYWORD.add("continue");
        KEYWORD.add("default");
        KEYWORD.add("do");
        KEYWORD.add("double");
        KEYWORD.add("else");
        KEYWORD.add("extends");
        KEYWORD.add("final");
        KEYWORD.add("finally");
        KEYWORD.add("float");
        KEYWORD.add("for");
        KEYWORD.add("goto");
        KEYWORD.add("if");
        KEYWORD.add("implements");
        KEYWORD.add("import");
        KEYWORD.add("instanceof");
        KEYWORD.add("int");
        KEYWORD.add("interface");
        KEYWORD.add("long");
        KEYWORD.add("native");
        KEYWORD.add("new");
        KEYWORD.add("package");
        KEYWORD.add("private");
        KEYWORD.add("protected");
        KEYWORD.add("public");
        KEYWORD.add("return");
        KEYWORD.add("short");
        KEYWORD.add("static");
        KEYWORD.add("strictfp");
        KEYWORD.add("super");
        KEYWORD.add("switch");
        KEYWORD.add("synchronized");
        KEYWORD.add("this");
        KEYWORD.add("throw");
        KEYWORD.add("throws");
        KEYWORD.add("transient");
        KEYWORD.add("try");
        KEYWORD.add("void");
        KEYWORD.add("volatile");
        KEYWORD.add("while");
        KEYWORD.add("assert");
        KEYWORD.add("enum");
        KEYWORD.add("goto");
        KEYWORD.add("const");
        KEYWORD.add("strictfp");
        KEYWORD.add("true");
        KEYWORD.add("false");
        KEYWORD.add("null");
    }
}

