/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.kwt.xsl;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.koiroha.kwt.file.FileServlet;
import org.koiroha.kwt.xsl.Cache;
import org.koiroha.kwt.xsl.Config;

public class XSLTServlet
extends FileServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(XSLTServlet.class.getName());
    private final Map<String, Cache> cache = Collections.synchronizedMap(new HashMap());
    private Config config = null;

    @Override
    public void init() throws ServletException {
        super.init();
        ServletContext servletContext = this.getServletContext();
        File file = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
        if (file == null) {
            file = new File(System.getProperty("java.io.tmpdir", "."));
        }
        logger.finest("temporary directory: " + file);
        Enumeration enumeration = this.getInitParameterNames();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.getInitParameter(string);
            hashMap.put(string, string2);
            logger.finest("servlet parameter: " + string + "=" + string2);
        }
        this.config = new Config(hashMap, file, this.docroot);
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            long l;
            String string = httpServletRequest.getServletPath();
            URI uRI = this.getLocalURI(string, false);
            if (uRI == null) {
                Cache cache = this.cache.remove(string);
                if (cache != null) {
                    cache.delete();
                }
                logger.finest("return 404 not found response: " + string);
                httpServletResponse.sendError(404);
                return;
            }
            Cache cache = this.cache.get(string);
            if (cache == null) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("schema", httpServletRequest.getScheme());
                hashMap.put("server-name", httpServletRequest.getServerName());
                hashMap.put("server-port", String.valueOf(httpServletRequest.getServerPort()));
                hashMap.put("context-path", httpServletRequest.getContextPath());
                hashMap.put("path-info", string);
                cache = new Cache(this.config, httpServletRequest.getContextPath(), this.docroot, uRI, hashMap);
                this.cache.put(string, cache);
            }
            if ((l = httpServletRequest.getDateHeader("If-Modified-Since")) > 0L && !cache.isModifiedSince(l)) {
                httpServletResponse.setStatus(304);
                logger.finer("not modified");
                return;
            }
            boolean bl = this.config.isUseCompression() && this.acceptGZIPCompression(httpServletRequest);
            File file = cache.getCompiledFile(bl);
            httpServletResponse.setContentType(cache.getContentType());
            httpServletResponse.setHeader("Content-Length", Long.toString(file.length()));
            if (bl) {
                httpServletResponse.setHeader("Content-Encoding", "gzip");
                logger.finest("gzip compressed response");
            }
            this.send(file, (OutputStream)httpServletResponse.getOutputStream(), false);
            logger.finest("finish xsl servlet");
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.toString(), exception);
            httpServletResponse.sendError(500);
        }
    }
}

