/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.kwt.xsl;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.text.DateFormat;
import java.util.Date;

public final class Dependency
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final URI uri;
    private final File file;
    private long lastModified = -1L;

    public Dependency(URI uRI) {
        assert (uRI.isAbsolute());
        this.uri = uRI;
        String string = uRI.getScheme();
        if (!string.equalsIgnoreCase("file")) {
            this.file = null;
        } else {
            String string2 = uRI.getPath();
            string2 = string2.replace('/', File.separatorChar);
            this.file = new File(string2);
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public void reset() {
        this.lastModified = this.file == null ? 0L : this.file.lastModified();
    }

    public boolean isModified() {
        if (this.file == null) {
            return false;
        }
        return this.file.lastModified() != this.lastModified;
    }

    public String toString() {
        return this.uri.toString() + "[" + DateFormat.getDateTimeInstance().format(new Date(this.lastModified)) + "]";
    }
}

