/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.kwt.xsl;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import org.koiroha.kwt.xsl.SchemaCatalog;
import org.koiroha.kwt.xsl.TransformationHandler;
import org.koiroha.kwt.xsl.XSLErrorHandler;
import org.xml.sax.ErrorHandler;

public final class Config
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Config.class.getName());
    private final Map<String, String> config = new HashMap<String, String>();
    private final File tempdir;
    private final SchemaCatalog catalog;
    private final List<TransformationHandler> handler;
    public static final String DEFAULT_XSL_URI = "default-xsl-uri";
    public static final String DTD_VALIDATION_ERROR = "dtd-validation-error";
    public static final String XML_SCHEMA_VALIDATION_ERROR = "xml-schema-validation-error";
    public static final String USE_COMPRESSION = "use-compression";
    public static final String KEEP_TRANSFORMED_XML = "keep-transformed-xml";
    public static final String TRANSFORMATION_HANDLERS = "transformation-handlers";
    public static final String SCHEMA_CATALOG = "schema-catalog";

    Config(Map<String, String> map, File file, URI uRI) throws ServletException {
        Object object;
        this.tempdir = file;
        this.config.putAll(map);
        ArrayList<TransformationHandler> arrayList = new ArrayList<TransformationHandler>();
        String string = this.getString(TRANSFORMATION_HANDLERS, "");
        try {
            object = new StringTokenizer(string, ", \t\r\n");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string2 = ((StringTokenizer)object).nextToken();
                arrayList.add((TransformationHandler)Class.forName(string2).newInstance());
                logger.config("load transformation handler: " + string2);
            }
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "fail to load transformation handler", exception);
            throw new ServletException((Throwable)exception);
        }
        this.handler = Collections.unmodifiableList(arrayList);
        string = this.getString(SCHEMA_CATALOG, "");
        if (string.length() > 0) {
            while (string.startsWith("/")) {
                string = string.substring(1);
            }
            object = uRI.resolve(string);
            this.catalog = new SchemaCatalog((URI)object, file);
        } else {
            this.catalog = new SchemaCatalog(null, file);
        }
    }

    public String getString(String string, String string2) {
        String string3 = this.config.get(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public boolean getBoolean(String string, boolean bl) {
        String string2 = this.config.get(string);
        if (string2 == null) {
            return bl;
        }
        return Boolean.valueOf(string2);
    }

    public File getTempdir() {
        return this.tempdir;
    }

    public SchemaCatalog getSchemaCatalog() {
        return this.catalog;
    }

    public List<TransformationHandler> getTransformerHandlers() {
        return this.handler;
    }

    public URI getDefaultXSLURI() {
        String string = this.getString(DEFAULT_XSL_URI, null);
        if (string == null) {
            return null;
        }
        return URI.create(string);
    }

    public ErrorHandler getDTDValidationErrorHandler(String string) {
        return Config.getErrorHandler(string, this.config.get(DTD_VALIDATION_ERROR));
    }

    public ErrorHandler getXMLSchemaValidationErrorHandler(String string) {
        return Config.getErrorHandler(string, this.config.get(XML_SCHEMA_VALIDATION_ERROR));
    }

    public boolean isUseCompression() {
        return this.getBoolean(USE_COMPRESSION, true);
    }

    public boolean isKeepTransformedXML() {
        return this.getBoolean(KEEP_TRANSFORMED_XML, false);
    }

    public static File getCacheDirectory(File file, String string) {
        String string2 = Config.class.getName();
        int n = string2.lastIndexOf(46);
        String string3 = string2.substring(0, n);
        String string4 = string3.replace('.', File.separatorChar);
        return new File(file, string4 + File.separator + string);
    }

    private static ErrorHandler getErrorHandler(String string, String string2) {
        if (string2 == null || string2.trim().length() == 0) {
            return null;
        }
        if ((string2 = string2.trim()).equalsIgnoreCase("fail")) {
            return new XSLErrorHandler(string, Level.SEVERE, true);
        }
        if (string2.equalsIgnoreCase("logging")) {
            return new XSLErrorHandler(string, Level.WARNING, false);
        }
        Pattern pattern = Pattern.compile("logging\\s*\\(\\s*([^\\s\\)]*)\\s*\\)", 2);
        Matcher matcher = pattern.matcher(string2);
        if (matcher.matches()) {
            Level level = Level.WARNING;
            try {
                if (matcher.group().length() != 0) {
                    level = Level.parse(matcher.group(1).toUpperCase());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.warning("unrecognizable logging level: " + matcher.group(1) + ";" + " use default level: " + level.getName());
            }
            return new XSLErrorHandler(string, level, false);
        }
        logger.warning("unrecognizable validation-error spec: " + string2);
        return null;
    }
}

