/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.kwt.xsl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.koiroha.kwt.xsl.Config;
import org.koiroha.kwt.xsl.Dependency;
import org.koiroha.kwt.xsl.DependencyCapture;
import org.koiroha.kwt.xsl.SchemaCatalog;
import org.koiroha.kwt.xsl.TransformationHandler;
import org.koiroha.kwt.xsl.XSLErrorListener;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

final class Cache
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Cache.class.getName());
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();
    private final Config config;
    private final URI docroot;
    private final Dependency xml;
    private List<Dependency> dependency = new ArrayList<Dependency>();
    private final File cache;
    private final File cacheGZ;
    private String contentType = "text/html";
    private long lastAccess = -1L;
    private final Map<String, String> param;
    private final DocumentBuilderFactory documentBuilderFactory;

    public Cache(Config config, String string, URI uRI, URI uRI2, Map<String, String> map) throws IOException, SAXException {
        logger.finest("creating cache space: " + uRI.relativize(uRI2) + " (" + map + ")");
        this.config = config;
        URI uRI3 = uRI.relativize(uRI2);
        String string2 = string + File.separator + uRI3.toString().replace('/', File.separatorChar);
        File file = Config.getCacheDirectory(config.getTempdir(), "transform");
        String string3 = file.getAbsolutePath() + File.separator + string2;
        File file2 = new File(string3);
        file2 = Cache.changeExtension(file2, ".html");
        logger.finest("cache file: " + file2);
        this.docroot = uRI;
        this.cache = file2;
        this.cacheGZ = new File(file2.getParent(), file2.getName() + ".gz");
        this.xml = new Dependency(uRI2);
        this.param = new HashMap<String, String>(map);
        this.cache.getParentFile().mkdirs();
        ErrorHandler errorHandler = config.getDTDValidationErrorHandler("http://dummy");
        this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.documentBuilderFactory.setValidating(errorHandler != null);
        this.documentBuilderFactory.setNamespaceAware(true);
        this.documentBuilderFactory.setXIncludeAware(true);
        this.compile(this.dependency);
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isModifiedSince(long l) {
        if (!this.isCacheValid()) {
            return true;
        }
        return this.cache.isFile() && this.cache.lastModified() > l;
    }

    public File getCompiledFile(boolean bl) throws IOException, SAXException {
        if (!this.isCacheValid()) {
            ArrayList<Dependency> arrayList = new ArrayList<Dependency>();
            this.compile(arrayList);
            this.dependency = arrayList;
        } else {
            logger.finest("all dependencies are valid, cache available");
        }
        if (bl) {
            assert (this.config.isUseCompression());
            return this.cacheGZ;
        }
        return this.cache;
    }

    public void delete() {
        this.cache.delete();
        this.cacheGZ.delete();
        logger.fine("cache file removed: " + this.cache);
    }

    private boolean isCacheValid() {
        long l = System.currentTimeMillis();
        if (l - this.lastAccess <= 5000L) {
            return true;
        }
        this.lastAccess = l;
        List<Dependency> list = this.dependency;
        for (int i = 0; i < list.size(); ++i) {
            Dependency dependency = list.get(i);
            boolean bl = dependency.isModified();
            if (bl) {
                logger.fine("modification detected: " + this.docroot.relativize(dependency.getURI()));
                return false;
            }
            logger.finest("unmodified: " + this.docroot.relativize(dependency.getURI()));
        }
        if (!this.cache.isFile() || !this.cacheGZ.isFile()) {
            logger.finest("cache file removed");
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void compile(Collection<Dependency> collection) throws IOException, SAXException {
        logger.finest("start cache transformation");
        long l = System.currentTimeMillis();
        collection.add(this.xml);
        URI uRI = this.xml.getURI();
        logger.finest("reading xml file...: " + uRI);
        Document document = this.readDocument(uRI);
        document.setDocumentURI(uRI.toString());
        if (this.config.getXMLSchemaValidationErrorHandler(uRI.toString()) != null) {
            logger.finest("validating xml schema...: " + uRI);
            this.validateXmlSchema(document, uRI);
        } else {
            logger.finest("skipping xml schema validation");
        }
        this.jointDependency(uRI, collection, "http://www.w3.org/2001/XInclude", "include");
        for (TransformationHandler object2 : this.config.getTransformerHandlers()) {
            document = object2.process(document, this.docroot, uRI, collection);
        }
        logger.finest("finish to call transformation handler");
        Object object3 = this.getStylesheet(document);
        if (object3 == null) {
            logger.finest("xml stylesheet is not specified: " + uRI);
            this.transform(document, null);
            return;
        }
        if (!((URI)object3).isAbsolute()) {
            String string = ((URI)object3).toString();
            if (string.startsWith("/")) {
                void var7_8;
                String string2;
                while ((string2 = var7_8.substring(1)).startsWith("/")) {
                }
                object3 = this.docroot.resolve(string2);
            } else {
                object3 = uRI.resolve((URI)object3);
            }
        }
        collection.add(new Dependency((URI)object3));
        logger.finest("xsl stylesheet: " + object3);
        this.jointDependency((URI)object3, collection, "http://www.w3.org/1999/XSL/Transform", "import", "include");
        this.transform(document, (URI)object3);
        for (Dependency dependency : collection) {
            dependency.reset();
        }
        logger.fine("xsl transformation complete: " + this.cache.length() / 1024L + "kB: " + (System.currentTimeMillis() - l) + "ms: " + this.docroot.relativize(uRI));
        if (logger.isLoggable(Level.FINEST)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Dependency dependency : collection) {
                stringBuilder.append(", ");
                stringBuilder.append(this.docroot.relativize(dependency.getURI()));
            }
            logger.finest("depend " + collection.size() + " files" + stringBuilder);
        }
    }

    private URI getStylesheet(Document document) {
        NodeList nodeList = document.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof ProcessingInstruction)) continue;
            ProcessingInstruction processingInstruction = (ProcessingInstruction)nodeList.item(i);
            if (!processingInstruction.getTarget().equals("xml-stylesheet")) {
                logger.finest("not a xml-stylesheet: " + processingInstruction.getTarget());
                continue;
            }
            Pattern pattern = Pattern.compile("type\\s*=\\s*[\"']text/xsl[\"']");
            Matcher matcher = pattern.matcher(processingInstruction.getData());
            if (!matcher.find()) {
                logger.finest("type is not text/xsl: " + processingInstruction.getData());
                continue;
            }
            pattern = Pattern.compile("href\\s*=\\s*[\"']([^\"']*)[\"']");
            matcher = pattern.matcher(processingInstruction.getData());
            if (!matcher.find()) {
                logger.finest("href not found: " + processingInstruction.getTarget());
                continue;
            }
            return URI.create(matcher.group(1));
        }
        return this.config.getDefaultXSLURI();
    }

    private void jointDependency(URI uRI, Collection<Dependency> collection, String string, String ... stringArray) throws IOException {
        HashSet<URI> hashSet = new HashSet<URI>();
        DependencyCapture dependencyCapture = new DependencyCapture(uRI, hashSet, string, stringArray);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        sAXParserFactory.setValidating(false);
        sAXParserFactory.setXIncludeAware(false);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader object = sAXParser.getXMLReader();
            object.setContentHandler(dependencyCapture);
            object.setEntityResolver(this.config.getSchemaCatalog());
            object.parse(uRI.toString());
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
        for (URI uRI2 : hashSet) {
            Dependency dependency = new Dependency(uRI2);
            collection.add(dependency);
        }
    }

    private Document readDocument(URI uRI) throws IOException {
        Document document = null;
        try {
            DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
            logger.finest("reading xml: " + uRI + " (" + "namespace=" + documentBuilder.isNamespaceAware() + "," + "xinclude=" + documentBuilder.isXIncludeAware() + "," + "validating=" + documentBuilder.isValidating() + ")");
            documentBuilder.setEntityResolver(this.config.getSchemaCatalog());
            ErrorHandler errorHandler = this.config.getDTDValidationErrorHandler(uRI.toString());
            if (errorHandler != null) {
                documentBuilder.setErrorHandler(errorHandler);
            } else {
                logger.finest("skipping dtd validation");
            }
            InputSource inputSource = new InputSource(uRI.toURL().toString());
            document = documentBuilder.parse(inputSource);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transform(Document document, URI uRI) throws IOException {
        OutputStream outputStream = null;
        InputStream inputStream = null;
        DeflaterOutputStream deflaterOutputStream = null;
        try {
            Object object;
            this.cache.getParentFile().mkdirs();
            outputStream = new BufferedOutputStream(new FileOutputStream(this.cache));
            Cache.transform(outputStream, document, uRI, this.param);
            if (uRI == null) {
                this.contentType = "text/xml";
            }
            outputStream.close();
            if (this.config.isUseCompression()) {
                int n;
                deflaterOutputStream = new GZIPOutputStream(new FileOutputStream(this.cacheGZ));
                inputStream = new FileInputStream(this.cache);
                object = new byte[1024];
                while ((n = inputStream.read((byte[])object)) >= 0) {
                    ((GZIPOutputStream)deflaterOutputStream).write((byte[])object, 0, n);
                }
                inputStream.close();
                ((GZIPOutputStream)deflaterOutputStream).finish();
                deflaterOutputStream.close();
            }
            if (this.config.isKeepTransformedXML()) {
                object = new File(this.cache.getAbsolutePath() + ".xml");
                outputStream = new BufferedOutputStream(new FileOutputStream((File)object));
                Cache.transform(outputStream, document, null, this.param);
                outputStream.close();
            }
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (deflaterOutputStream != null) {
                    deflaterOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static void transform(OutputStream outputStream, Document document, URI uRI, Map<String, String> map) throws IOException {
        InputStream inputStream = null;
        try {
            Object object2;
            Transformer transformer = null;
            if (uRI == null) {
                transformer = TRANSFORMER_FACTORY.newTransformer();
            } else {
                inputStream = uRI.toURL().openStream();
                object2 = new StreamSource(inputStream);
                object2.setSystemId(uRI.toString());
                transformer = TRANSFORMER_FACTORY.newTransformer((Source)object2);
                inputStream.close();
                inputStream = null;
                if (transformer == null) {
                    throw new IOException(uRI.toString());
                }
                logger.finest("output method: " + transformer.getOutputProperty("method"));
            }
            if (map != null) {
                for (Map.Entry object3 : map.entrySet()) {
                    transformer.setParameter((String)object3.getKey(), object3.getValue());
                    logger.finest("set parameter: " + (String)object3.getKey() + "=" + (String)object3.getValue());
                }
            }
            object2 = new DOMSource(document);
            StreamResult streamResult = new StreamResult(outputStream);
            transformer.transform((Source)object2, streamResult);
        }
        catch (TransformerException transformerException) {
            throw new IOException(transformerException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static File changeExtension(File file, String string) {
        File file2 = file.getParentFile();
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        if (n >= 0) {
            string2 = string2.substring(0, n);
        }
        return new File(file2, string2 + string);
    }

    private void validateXmlSchema(Document document, URI uRI) throws SAXException {
        HashMap<String, Schema> hashMap = new HashMap<String, Schema>();
        this.retrieveXmlSchema(document.getDocumentElement(), uRI, hashMap);
        SchemaCatalog schemaCatalog = this.config.getSchemaCatalog();
        ErrorHandler errorHandler = this.config.getXMLSchemaValidationErrorHandler(uRI.toString());
        for (Schema schema : hashMap.values()) {
            Validator validator = schema.newValidator();
            validator.setErrorHandler(errorHandler);
            validator.setResourceResolver(schemaCatalog);
            DOMSource dOMSource = new DOMSource(document);
            dOMSource.setSystemId(uRI.toString());
            try {
                validator.validate(dOMSource);
            }
            catch (IOException iOException) {
                logger.log(Level.SEVERE, "unexpected error", iOException);
            }
        }
    }

    private void retrieveXmlSchema(Element element, URI uRI, Map<String, Schema> map) {
        Object object;
        int n;
        Object object2;
        String string = "http://www.w3.org/2001/XMLSchema-instance";
        if (element.hasAttributeNS(string, "schemaLocation")) {
            object2 = element.getAttributeNS(string, "schemaLocation");
            String[] stringArray = ((String)object2).split("[ \t\r\n]+");
            n = 0;
            while (n + 1 < stringArray.length) {
                object = this.getXmlSchema(uRI, stringArray[n], stringArray[n + 1]);
                if (object != null) {
                    map.put(stringArray[n], (Schema)object);
                }
                n += 2;
            }
        }
        object2 = element.getAttributes();
        for (int i = 0; i < object2.getLength(); ++i) {
            Schema schema;
            Attr attr = (Attr)object2.item(i);
            if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()) || (schema = this.getXmlSchema(uRI, (String)(object = attr.getValue()))) == null) continue;
            map.put((String)object, schema);
        }
        NodeList nodeList = element.getChildNodes();
        for (n = 0; n < nodeList.getLength(); ++n) {
            if (!(nodeList.item(n) instanceof Element)) continue;
            this.retrieveXmlSchema((Element)nodeList.item(n), uRI, map);
        }
    }

    private Schema getXmlSchema(URI uRI, String string, String string2) {
        SchemaCatalog schemaCatalog = this.config.getSchemaCatalog();
        try {
            URL uRL = uRI.resolve(string2).toURL();
            return schemaCatalog.getXmlSchema(string, uRL.toString());
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "unexpected error", exception);
            return null;
        }
    }

    private Schema getXmlSchema(URI uRI, String string) {
        SchemaCatalog schemaCatalog = this.config.getSchemaCatalog();
        try {
            return schemaCatalog.getXmlSchema(string);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "unexpected error", exception);
            return null;
        }
    }

    static {
        TRANSFORMER_FACTORY.setErrorListener(new XSLErrorListener());
    }
}

