/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.kwt.file;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;

public class FileServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private int sendBufferSize = 4096;
    protected URI docroot = null;

    public void init() throws ServletException {
        super.init();
        try {
            this.docroot = this.getLocalURI("/", true);
        }
        catch (IOException iOException) {
            throw new ServletException((Throwable)iOException);
        }
    }

    protected URI getLocalURI(String string, boolean bl) throws IOException {
        Serializable serializable;
        ServletContext servletContext = this.getServletContext();
        String string2 = servletContext.getRealPath(string);
        if (string2 != null) {
            serializable = new File(string2);
            if (!bl && ((File)serializable).isFile() || bl && ((File)serializable).isDirectory()) {
                return ((File)serializable).toURI();
            }
        }
        if ((serializable = servletContext.getResource(string)) != null) {
            try {
                return ((URL)serializable).toURI();
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IOException(uRISyntaxException);
            }
        }
        return null;
    }

    protected boolean acceptGZIPCompression(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader("Accept-Encoding");
        if (string == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", \t\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            if (!stringTokenizer.nextToken().equalsIgnoreCase("gzip")) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send(File file, OutputStream outputStream, boolean bl) throws IOException {
        if (bl) {
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(outputStream);
            this.send(file, gZIPOutputStream, false);
            gZIPOutputStream.finish();
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(file);
            int n2 = (int)Math.min((long)this.sendBufferSize, file.length());
            byte[] byArray = new byte[n2];
            while ((n = fileInputStream.read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n);
            }
            outputStream.flush();
        }
        catch (Throwable throwable) {
            FileServlet.close(fileInputStream);
            throw throwable;
        }
        FileServlet.close(fileInputStream);
    }

    protected static void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

