<?php
/* 
 * $Id: smarty.inc.php,v 1.5 2005/02/26 08:58:38 youka Exp $
 */
require_once('smarty/Smarty.class.php');


class MySmarty extends Smarty
{
	function __construct($template_dir)
	{
		$this->Smarty();
		
		$this->template_dir = $template_dir;
		$this->compile_dir = COMPILEDTPL_DIR;
		$this->config_dir = './system/smarty/config/';
		$this->cache_dir = './system/smarty/cache/';
		
		$this->assign('script', SCRIPTPATH);
		$this->assign('skin_dir', dirname(SCRIPTPATH) . '/' . SKIN_DIR);
		$this->assign('cmd_dir', dirname(SCRIPTPATH) . '/' . CMD_DIR);
		$this->assign('plugin_dir', dirname(SCRIPTPATH) . '/' . PLUGIN_DIR);
		$this->assign('sitename', SITENAME);
		$this->register_function('showpage', array('MySmarty', 'showpage'));
		$this->register_modifier('makelink', array('MySmarty', 'makelink'));
		$this->register_modifier('topicpath', array('MySmarty', 'topicpath'));
		$this->register_modifier('decorate_diff', array('MySmarty', 'decorate_diff'));
		$this->register_modifier('date', array('MySmarty', 'date'));
	}
	
	
	/**
	 * Wikiのページをhtmlにして取得する。Smartyプラグイン用。
	 */
	function showpage($param)
	{
		if(!isset($param['page'])){
			return '';
		}
		$page = Page::getinstance($param['page']);
		return convert_block($page->getsource(), $page->getpagename());
	}
	
	
	/**
	 * Wikiのページ名を元にリンクを作る。Smartyプラグイン用。
	 */
	function makelink($pagename, $alias = '')
	{
		return makelink($pagename, $alias);
	}
	
	
	/**
	 * Wikiのページ名を元にパンくずリストを作る。Smartyプラグイン用。
	 */
	function topicpath($pagename)
	{
		$path = explode('/', $pagename);
		$list = array();
		for($i = 0; $i < count($path); $i++){
			$list[] = makelink(join('/', array_slice($path, 0, $i+1)), $path[$i]);
		}
		return join(' &gt; ', $list);
	}


	/**
	 * 差分テキストに色つけタグをつける。Smartyプラグイン用。
	 */
	function decorate_diff($diff)
	{
		$diff = explode("\n", $diff);
		for($i = 0; $i < count($diff); $i++){
			$diff[$i] = mb_ereg_replace('^\+(.*)$', '+<span class="diff_add">\1</span>', $diff[$i]);
			$diff[$i] = mb_ereg_replace('^-(.*)$', '-<span class="diff_del">\1</span>', $diff[$i]);
		}
		return join("\n", $diff);
	}


	/**
	 * タイムスタンプを日時に変換する。Smartyプラグイン用。
	 */
	function date($timestamp)
	{
		static $daytable = array('日', '月', '火', '水', '木', '金', '土');
		
		$date = date('Y-m-d', $timestamp);
		$day = $daytable[date('w', $timestamp)];
		$time =date('H:i:s', $timestamp);
		return "$date ($day) $time";
	}
}



class PluginSmarty extends MySmarty
{
	function __construct($pluginname)
	{
		parent::__construct(PLUGIN_DIR . $pluginname . '/');
		$this->compile_id = "p_$pluginname";
	}
}



class CmdSmarty extends MySmarty
{
	function __construct($cmdname)
	{
		parent::__construct(CMD_DIR . $cmdname . '/');
		$this->compile_id = "c_$cmdname";
	}
}


?>