<?php
require_once(PLUGIN_DIR . '/blognavi/plugin.inc.php');


class Plugin_blogviewer extends Plugin
{
	function do_block($pagename, $param1, $param2)
	{
		if(!mb_ereg('^\s*(.+?)\s*,\s*(\d+)\s*$', $param1, $m) || $m[2] <= 0){
			throw new PluginException('引数が正しくありません。', 'blogviewer');
		}
		$home = $m[1];
		$num = $m[2];
		
		$get = KinoWiki::getinstance()->getGET();
		$p = isset($get['p']) ? max(0, $get['p']) : 0;
		
		$datelist = Plugin_blognavi_DateList::getinstance($home);
		$collist = Plugin_blognavi_ColumnList::getinstance($datelist);
		$page = $collist->getlast();
		for($i = 0; $i < $num*$p; $i++){
			$page = $collist->getprev($page);
		}
		$ret = array();
		for($i = 0; $i < $num; $i++){
			if($page == null){
				break;
			}
			$ret[] = $this->includepage($page);
			$page = $collist->getprev($page);
		}
		
		$smarty = new PluginSmarty('blogviewer');
		$smarty->assign('pagename', $pagename);
		if($p > 0){
			$smarty->assign('next', $p - 1);
		}
		$smarty->assign('prev', $p + 1);
		$smarty->assign('body', join("\n", $ret));
		return $smarty->fetch('blogviewer.tpl.htm');
	}
	
	
	protected function includepage($pagename)
	{
		$source = Page::getinstance($pagename)->getsource();
		$source = mb_ereg_replace('#blognavi', '', $source);
		$smarty = new PluginSmarty('blogviewer');
		$smarty->assign('title', $pagename);
		$smarty->assign('body', convert_block($source, $pagename));
		return $smarty->fetch('include.tpl.htm');
	}
}


?>