<?php
/**
 * 例外用クラス。
 */
class MyException extends exception
{
	/**
	 * コンストラクタ
	 * 
	 * 最初に作ったのインターフェースとの互換性のため第１引数のみを取る。
	 */
	public function __construct($mes = '')
	{
		parent::__construct($mes);
		if(defined('DEBUGMODE') && DEBUGMODE == true){
			$this->savedump();
		}
	}
	
	
	/**
	 * getMessage()のalias
	 * 
	 * 最初に作ったのインターフェースの互換性のために残す。
	 */
	public function message()
	{
		return $this->getMessage();
	}
	
	
	/**
	 * デバッグ情報をファイルに保存する
	 * 
	 * @return	bool	成功すればtrue
	 */
	protected function savedump()
	{
		$fp = fopen(DATA_DIR . WIKIID . '.error.log', 'a');
		if($fp == false){
			return false;
		}
		
		$str[] = date('Y-m-d H:i:s');
		$str[] = $this->getFile() . '(' . $this->getLine() . ')';
		$str[] = $this->getMessage();
		$str[] = $this->getTraceAsString();
		$str[] = "\n\n";
		$ret = fwrite($fp, join("\n", $str));
		fclose($fp);
		return $ret !== false ? true : false;
	}
}


/**
 * SQLite関連の例外クラス。
 */
class DBException extends MyException
{
	public function __construct($mes = '', $dblink)
	{
		parent::__construct($mes . "\n" . sqlite_error_string(sqlite_last_error($dblink)));
	}
}


/**
 * プラグインの例外クラス。
 */
class PluginException extends MyException
{
	public function __construct($mes = '', $pluginname)
	{
		parent::__construct($mes . "($pluginname)");
	}
}


/**
 * コマンドの例外クラス。
 */
class CmdException extends MyException
{
	public function __construct($mes = '', $cmdname)
	{
		parent::__construct($mes . "($cmdname)");
	}
}


?>