<?php
/*
 * $Id: plugin.inc.php,v 1.2 2004/08/31 03:20:57 youka Exp $
 */


class Plugin_rss extends Plugin
{
	function do_block($pagename, $param1, $param2)
	{
		$param = array_map('trim', explode(',', $param1));
		if(!isset($param[0])){
			throw new PluginException('引数がありません', 'rss');
		}
		
		$url = $param[0];
		$expire = isset($param[1]) ? (int)$param[1] : 0;
		
		if($expire == 0){
			return $this->getrss($url);
		}
		else{
			$db = DataBase::getinstance();
			$db->begin();
			
			$_url = $db->escape($url);
			$row = $db->fetch($db->query("SELECT data,time FROM plugin_rss WHERE url = '$_url'"));
			if($row == false || $row['time'] + $expire * 60 < TIME){
				$data = $this->getrss($url);
				$_data = $db->escape($data);
				$query  = "INSERT OR REPLACE INTO plugin_rss (url,data,time)";
				$query .= " VALUES('$_url', '$_data', " . TIME . ")";
				$db->query($query);
			}
			else{
				$data = $row['data'];
			}
			
			$db->commit();
			return $data;
		}
	}
	
	
	protected function getrss($url)
	{
		require_once('XML/RSS.php');
		
		$rss = new XML_RSS($url);
		$rss->parse();
		
		$ret[] = '<ul class="plugin_rss">';
		foreach($rss->getItems() as $i){
			$ret[] = '<li><a href="' . $i['link'] . '">' . mb_convert_encoding($i['title'], 'UTF-8', 'auto') . '</a></li>';
		}
		$ret[] = '</ul>';
		return join("\n", $ret);
	}
	
	
	function do_url()
	{
		$db = DataBase::getinstance();
		$db->begin();
		
		$ret['title'] = 'rssプラグイン';
		if($db->istable('plugin_rss')){
			$ret['body'] = '<p>rssプラグインはインストール済みです。</p>';
		}
		else{
			$db->query(file_get_contents(PLUGIN_DIR . 'rss/rss.sql'));
			$ret['body'] = '<p>rssプラグインをインストールしました。</p>';
		}
		
		$db->commit();
		return $ret;
	}
}

?>