<?php



/**
 * Wiki１つを表すクラス。
 * 
 * Wikiごとにシングルトン。
 */
class Wiki
{
	protected $wikiid;	//WikiFarmのID
	
	
	function getwikiid(){ return $this->wikiid; }
	
	
	
	/**
	 * インスタンスを取得する。IDごとにシングルトン。
	 * 
	 * @param	$id	WikiFarmのID。指定しない場合は現在のWikiFarmのIDが使われる。
	 */
	static function getinstance($id = WIKIID)
	{
		static $ins = array();
		
		if(!isset($ins[$id])){
			$ins[$id] = new BackupedWiki($id);
		}
		return $ins[$id];
	}
	
	
	/**
	 * コンストラクタ。
	 */
	protected function __construct($id)
	{
		$this->wikiid = $id;
	}
	
	
	/**
	 * Pageを取得する。
	 * 
	 * @return	Page
	 */
	function getPage($pagename)
	{
		return Page::getinstance($pagename, $this->wikiid);
	}
	
	
	/**
	 * ページが存在するかどうかを確認する。
	 * 
	 * @return	bool	存在する場合はtrueを返す。
	 */
	function ispage($pagename)
	{
		$page = $this->getPage($pagename);
		return $page->getsource() != '';
	}
	
	
	/**
	 * ページ検索する。
	 * 
	 * @param	array(string)	$word	検索語句。
	 * @param	bool	$andsearch	trueの場合はAND検索、falseの場合はOR検索。
	 * @return	array(string)	ページ名。アルファベット順にソート済み。
	 */
	function normalsearch($word, $andsearch = true)
	{
		return Search::getinstance($this->wikiid)->normalsearch($word, $andsearch);
	}
	
	
	/**
	 * あいまい検索する。
	 * 
	 * @param	array(string)	$word	検索語句。
	 * @param	bool	$andsearch	trueの場合はAND検索、falseの場合はOR検索。
	 * @return	array(string)	ページ名。アルファベット順にソート済み。
	 */
	function fuzzysearch($word, $andsearch = true)
	{
		return Search::getinstance($this->wikiid)->fuzzysearch($word, $andsearch);
	}
	
	
	/**
	 * 正規表現検索する。
	 * 
	 * @param	array(string)	$word	検索語句。
	 * @param	bool	$andsearch	trueの場合はAND検索、falseの場合はOR検索。
	 * @return	array(string)	ページ名。アルファベット順にソート済み。
	 */
	function eregsearch($word, $andsearch = true)
	{
		return Search::getinstance($this->wikiid)->eregsearch($word, $andsearch);
	}
	
	
	/**
	 * 更新日時でページ検索する。
	 * 
	 * @param	int	$from	開始日時のタイムスタンプ
	 * @param	int	$to	終了日時のタイムスタンプ
	 * @return	array(string)	ページ名。新しい順にソート済み。
	 */
	function timesearch($from, $to)
	{
		return Search::getinstance($this->wikiid)->timesearch($from, $to);
	}
}


?>