<?php



/**
 * ページ更新時にメールを送るクラス。
 */
class Mail /* implements PageObserver */
{
	/**
	 * ページ更新と同時にメールを送る。
	 */
	static function update($page)
	{
		if(!MAIL_USE){
			return;
		}
		
		$pagename = $page->getpagename();
		if($page->getsource() == ''){
			$head = "「{$pagename}」が削除されました。";
		}
		else if($page->getsource(1) == ''){
			$head = "「{$pagename}」が作成されました。";
		}
		else{
			$head = "「{$pagename}」が変更されました。";
		}
		
		$diff = $page->diff(0, 1);
		$renderer = new DiffRenderer($diff);
		$source = $renderer->render(MAIL_DIFF);
		
		$subject = '[KinoWiki-' . WIKIID . "] $pagename";
		$text[] = $head;
		$text[] = '';
		$text[] = 'WikiID: ' . WIKIID;
		$text[] = date('Y-m-d H:i:s', TIME);
		$text[] = 'REMOTE_HOST: ' . gethostbyaddr($_SERVER['REMOTE_ADDR']);
		$text[] = 'REMOTE_ADDR: ' . $_SERVER['REMOTE_ADDR'];
		$text[] = '';
		$text[] = '--------------------';
		$text[] = $source;
		sendmail($subject, join("\n", $text));
	}
}

?>