<?php
/* 
 * $Id: kinowiki.inc.php,v 1.2 2004/08/14 02:23:23 youka Exp $
 */

ini_set('include_path', './' . PATH_SEPARATOR . ini_get('include_path'));

require_once('page.inc.php');
require_once('wiki.inc.php');
require_once('attach.inc.php');
require_once('autolink.inc.php');
require_once('backlink.inc.php');
require_once('backup.inc.php');
require_once('charentityref.inc.php');
require_once('diff.inc.php');
require_once('database.inc.php');
require_once('exception.inc.php');
require_once('func.inc.php');
require_once('htmlconverter.inc.php');
require_once('mail.inc.php');
require_once('parser.inc.php');
require_once('plugin.inc.php');
require_once('smarty.inc.php');
require_once('search.inc.php');
require_once('trackback.inc.php');
require_once('version.inc.php');

header('Content-Type: text/html; charset=UTF-8');
mb_internal_encoding('UTF-8');
mb_regex_encoding('UTF-8');


/**
 * アプリケーションを表すクラス。
 */
class KinoWiki
{
	protected $pagename = null;	//現在実行中のページ名
	
	protected $post = null;	//デコード済みのQueryString
	protected $get = null;	//デコード済みのQueryString
	protected $cookie = null;	//デコード済みのcookie
	
	protected $skinfile;	//使用するスキン
	protected $theme;	//使用するテーマ
	protected $noframe;	//ページ本文に枠をつけるか否か
	
	
	/**
	 * インスタンスを取得する。シングルトン。
	 */
	static function getinstance()
	{
		static $ins = null;
		
		if($ins == null){
			$ins = new KinoWiki();
		}
		return $ins;
	}
	
	
	/**
	 * コンストラクタ。
	 */
	protected function KinoWiki()
	{
		$this->post = $_POST;
		$this->get = $_GET;
		$this->cookie = $_COOKIE;
		
		if(get_magic_quotes_gpc()){
			$this->post = map($this->post, 'stripslashes');
			$this->get = map($this->get, 'stripslashes');
			$this->cookie = map($this->cookie, 'stripslashes');
		}
		$this->get = map($this->get, 'rawurldecode');
		
		$this->skinfile = SKINFILE;
		$this->theme = THEME;
		
		$this->init();
	}
	
	
	/**
	 * アプリケーションの初期化。
	 */
	protected function init()
	{
		define('TIME', time());	//起動時の時間。
		$protocol = strtolower(array_shift(explode('/', $_SERVER['SERVER_PROTOCOL'])));
		define('SCRIPTPATH', $protocol . '://' . $_SERVER['SERVER_NAME'] . $_SERVER['SCRIPT_NAME']);	//自分自身のパス
	}
	
	
	/**
	 * 実行中のページ名を取得する。
	 */
	function getpagename()
	{
		return $this->pagename;
	}
	
	
	/**
	 * スキンを変更する。
	 */
	function setskinfile($filename)
	{
		$this->filename = $filename;
	}
	
	
	/**
	 * テーマを変更する。
	 */
	function settheme($themename)
	{
		$this->theme = $themename;
	}
	
	
	/**
	 * ページ本文の枠の有無を変更する。
	 * 
	 * @param	bool	$use	trueなら枠を使う。falseなら使わない。
	 */
	function setframe($use)
	{
		$this->noframe = !$use;
	}
	
	
	/**
	 * 実行。
	 */
	function run()
	{
		$starttime = mtime();
		
		try{
			if(isset($this->get['cmd'])){
				$ret = $this->callcmd($this->get['cmd']);
			}
			else if(isset($this->get['plugin'])){
				$plugin = Plugin::getPlugin($this->get['plugin']);
				$ret = $plugin->do_url($this->get['plugin']);
			}
			else{
				if(isset($this->get['page'])){
					$this->pagename = $this->get['page'];
				}
				else{
					$this->pagename = $_SERVER['QUERY_STRING'] == '' ? DEFAULTPAGE : rawurldecode($_SERVER['QUERY_STRING']);
				}
				$this->pagename = resolvepath($this->pagename);
				
				$ret = $this->showpage($this->pagename);
			}
		}
		catch(MyException $exc){
			$ret['title'] = 'error';
			$ret['body'] = nl2br(htmlspecialchars($exc->message()));
		}
		
		$ret['title'] = htmlspecialchars($ret['title']);
		if(isset($this->get['word'])){
			$word = $this->get['word'];
			$word = mb_split('[\s　]+', $word);
			$type = isset($this->get['type']) ? $this->get['type'] : 'normal';
			$ret['title'] = $this->markword($ret['title'], $word, $type);
			$ret['body'] = $this->markword($ret['body'], $word, $type);
		}
		
		$smarty = new MySmarty(SKIN_DIR);
		$smarty->assign('version', KINOWIKI_VERSION);
		$smarty->assign('theme', $this->theme);
		$smarty->assign('noframe', $this->noframe);
		$smarty->assign($ret);
		$endtime = mtime();
		$smarty->assign('runningtime', $endtime - $starttime);
		$smarty->display($this->skinfile);
	}
	
	
	/**
	 * コマンドを呼び出す。
	 * 
	 * @return	array('title' => string, 'body' => string)	呼び出せなかったときはその旨を返す。
	 */
	protected function callcmd($cmd)
	{
		$file = CMD_DIR . $cmd . '/' . $cmd . '.inc.php';
		if(is_file($file)){
			require_once($file);
			$class = eval("return Cmd_${cmd}::getinstance();");
			return $class->run();
		}
		else{
			$ret['title'] = 'error';
			$smarty = new MySmarty(TPL_DIR);
			$smarty->assign('commandname', $this->get['cmd']);
			$ret['body'] = $smarty->fetch('cmdnotfound.tpl.htm');
			return $ret;
		}
	}
	
	
	/**
	 * ページを表示する。
	 * 
	 * @return	array('title' => string, 'body' => string)	呼び出せなかったときはその旨を返す。
	 */
	protected function showpage($pagename)
	{
		$page = Page::getinstance($pagename);
		if($page->getsource() == ''){
			$ret['title'] = "$pagename は存在しません";
			$smarty = new MySmarty(TPL_DIR);
			$smarty->assign('pagename', $pagename);
			$ret['body'] = $smarty->fetch('notexist.tpl.htm');
		}
		else{
			$ret['title'] = $pagename;
			$ret['body'] = convert_block($page->getsource(), $pagename);
			$ret['pagename'] = $pagename;
			$ret['lastmodified'] = $page->gettimestamp();
			$ret['lastmodified_old'] = getold($page->gettimestamp());
			$ret['footnote'] = Footnote::getinstance()->getnote();
			$backlink = BackLink::getinstance()->getlist($pagename);
			if($backlink != array()){
				$smarty = new MySmarty(TPL_DIR);
				$smarty->assign('backlink', $backlink);
				$ret['backlink'] = $smarty->fetch('backlink.tpl.htm');
			}
			$attach = Attach::getinstance($pagename)->getlist();
			if($attach != array()){
				$smarty = new MySmarty(TPL_DIR);
				$smarty->assign('attach', $attach);
				$smarty->assign('pagename', $pagename);
				$ret['attach'] = $smarty->fetch('attach.tpl.htm');
			}
			$ret['trackbackrdf'] = TrackBack::getinstance($pagename)->getpingurlrdf();
		}
		return $ret;
	}
	
	
	/**
	 * 検索語にタグをつける。
	 * 
	 * @param	string	$text	タグをつける対象
	 * @param	array(string)	$word	検索語
	 * @param	string	$type	検索の種類
	 */
	protected function markword($text, $word, $type)
	{
		$count = 1;
		foreach($word as $w){
			if($w == ''){
				continue;
			}
			
			switch($type){
				case 'fuzzy':
					$s = $this->_markword_fuzzy($w);
					break;
				case 'ereg':
					$s = $this->_markword_ereg($w);
					break;
				default:
					$s = $this->_markword_normal($w);
					break;
			}
			$pattern = "((?:\G|>)[^<]*?)($s)";
			$replace = "\\1<span class=\"search word$count\">\\2</span>";
			$text = mb_ereg_replace($pattern, $replace, $text, 'm');
			$count++;
		}
		return $text;
	}
	
	
	protected function _markword_normal($w)
	{
		return mb_ereg_quote($w);
	}
	
	
	protected function _markword_fuzzy($w)
	{
		require_once('kanatable.inc.php');
		
		$s = '';
		$len = mb_strlen($w);
		for($i = 0; $i < $len; $i++){
			$c = mb_strtolower(mb_convert_kana(mb_substr($w, $i, 1), 'KVCas'));
			$c = htmlspecialchars(isset($kanatable[$c]) ? $kanatable[$c] : $c);
			$s .= '[' . mb_ereg_quote($c) . '][ッー・゛゜、。]?';
		}
		return $s;
	}
	
	
	protected function _markword_ereg($w)
	{
		return $w;
	}
	
	
	/**
	 * POSTされたデータをデコードしたものを取得する。
	 */
	function getPOST()
	{
		return $this->post;
	}
	
	
	/**
	 * GETされたデータをデコードしたものを取得する。
	 */
	function getGET()
	{
		return $this->get;
	}
	
	
	/**
	 * cookie（デコード済み）を取得する。
	 */
	function getCOOKIE()
	{
		return $this->cookie;
	}
}



?>